/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.coordinator;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerAddCommand;
import com.cognos.pogo.contentmanager.ContentManagerDeleteCommand;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.contentmanager.ContentManagerUpdateCommand;
import com.cognos.pogo.contentmanager.coordinator.ServiceSynchronizer;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.logging.Slogger;
import com.cognos.pogo.logging.messages.ServiceErrorAuditMsg;
import com.cognos.pogo.logging.messages.ServiceEventAuditMsg;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.Service;
import com.cognos.pogo.pdk.Tracking;
import com.cognos.pogo.services.DispatcherServices;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.Version;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;

public class CMBootstrap {
    static final PogoLogger cat = PogoLogger.getLogger();
    static final LoggingRealm loggingRealm = LoggingRealmFactory.getInstance("DISP");
    static final Slogger slogger = loggingRealm.getLogger(CMBootstrap.class.getName());
    private String dispatcherName;
    private PogoEngine pogoEngine;
    private String dispatcherGUID;
    private static final String DISP_PROP_SERVERGROUP = "com.ibm.cognos.pogo.dispatcher.servergroup";
    private String runningState = "running";
    private boolean runningStateChange;
    private String symbolicName;
    private boolean editionChange;

    public CMBootstrap(PogoEngine engine) {
        this(PropertyInserter.getProperty("dispatcher.name"), engine);
    }

    public CMBootstrap(String dispatcherName, PogoEngine engine) {
        this(dispatcherName, engine, PropertyInserter.getProperty("dispatcher.symbolicname"));
    }

    public CMBootstrap(String dispatcherName, PogoEngine engine, String symbolicName) {
        this.dispatcherName = dispatcherName;
        this.pogoEngine = engine;
        this.symbolicName = symbolicName;
    }

    public void run() throws Exception {
        try {
            this.registerDispatcher();
            cat.info("Dispatcher was successfully registered in Content Manager.");
            if (slogger.isEnabledFor(ServiceEventAuditMsg.levelOf())) {
                ServiceEventAuditMsg msg = new ServiceEventAuditMsg("dispatcherBootstrap", "StartService");
                msg.setStatus("Info");
                String logData = DispatcherStrings.getInstance().getString("REGISTRATION_SUCCESS", new Object[]{this.dispatcherName});
                msg.setLogData(logData);
                slogger.log(msg);
            }
            return;
        }
        catch (SoapFaultException sfx) {
            if (cat.isErrorEnabled()) {
                cat.error("An attempt to register the dispatcher in Content Manager was unsuccessful.  Will retry periodically.");
                cat.error(sfx.getFault().asXML());
            }
            if (slogger.isEnabledFor(ServiceErrorAuditMsg.levelOf())) {
                ServiceErrorAuditMsg msg = new ServiceErrorAuditMsg(this.dispatcherName, "registerInCM");
                String errorMsg = DispatcherStrings.getInstance().getString("REGISTRATION_FAILURE", new Object[]{NodeIdGuidMapper.getContentManagerNID().toString()});
                msg.addErrorMessage(errorMsg);
                msg.addErrorMessage(sfx.getLocalizedMessage());
                msg.setLogData(sfx.getFault().asXML());
                slogger.log(msg);
            }
            throw sfx;
        }
        catch (Exception ex) {
            if (cat.isErrorEnabled()) {
                cat.error("An attempt to register the dispatcher in Content Manager was unsuccessful.  Will retry periodically.");
                cat.error(ex.getLocalizedMessage(), ex);
            }
            if (slogger.isEnabledFor(ServiceErrorAuditMsg.levelOf())) {
                ServiceErrorAuditMsg msg = new ServiceErrorAuditMsg(this.dispatcherName, "registerInCM");
                String errorMsg = DispatcherStrings.getInstance().getString("REGISTRATION_FAILURE", new Object[]{NodeIdGuidMapper.getContentManagerNID().toString()});
                msg.addErrorMessage(errorMsg);
                msg.addErrorMessage(ex);
                slogger.log(msg);
            }
            throw ex;
        }
    }

    void registerDispatcher() throws CommandExecutionException {
        String actualPath = this.updateExistingDispatchers();
        if (actualPath == null) {
            cat.info("Dispatcher object ", this.dispatcherName, " is not yet registered at.");
            cat.debug("Adding dispatcher ", this.dispatcherName, " to CM.");
            actualPath = this.addDispatcher(this.dispatcherName);
            this.runningStateChange = false;
            cat.debug("Added dispatcher, search path is ", actualPath);
        } else if (this.runningStateChange) {
            cat.info("Dispatcher object ", this.dispatcherName, " is already registered at ", actualPath, " and will be updated with new runningState=", this.runningState);
            this.updateDispatcherRunningState(actualPath);
        } else if (this.editionChange) {
            cat.info("Dispatcher object ", this.dispatcherName, " is already registered at ", actualPath, " and will be updated with new edition=", CMBootstrap.getVersion());
            this.updateEdition(actualPath);
        } else {
            cat.info("Dispatcher object ", this.dispatcherName, " is already registered at ", actualPath);
        }
        if (actualPath != null) {
            this.updateAllServices(actualPath);
            this.setTrackingId();
            this.saveDispatcherPath(actualPath);
        }
    }

    private void saveDispatcherPath(String actualPath) {
        this.pogoEngine.getContext().setAttribute("com.ibm.cognos.pogo.dispatcher.path", actualPath);
    }

    private void setTrackingId() {
        Tracking.getInstance().setRequestIDBasename(this.dispatcherGUID);
        NodeIdGuidMapper.getInstance().put(this.dispatcherGUID, NodeID.getSelf());
    }

    private String updateExistingDispatchers() throws CommandExecutionException {
        String edition;
        List<CMClass> resultList = this.getRegisteredDispatchers();
        if (resultList.size() == 0) {
            cat.debug("dispatcher ", this.dispatcherName, " is not (yet) registered.");
            return null;
        }
        if (resultList.size() > 1) {
            cat.error("Multiple CM objects with dispatcherPath=\"", this.dispatcherName, "\" all will be deleted");
            this.removeDispatchers(resultList);
            return null;
        }
        CMClass res = resultList.get(0);
        this.runningState = this.getPropertyValue(res, "runningState");
        this.runningStateChange = false;
        if ("standby".equals(this.runningState) || "disabled".equals(this.runningState)) {
            cat.debug("Dispatcher's runningState was \"" + this.runningState + "\", will update to \"running\"");
            this.runningState = "running";
            this.runningStateChange = true;
        }
        boolean bl = this.editionChange = (edition = this.getPropertyValue(res, "edition")) == null || !edition.equals(CMBootstrap.getVersion());
        if (!res.getCMClassName().endsWith("ispatcher")) {
            cat.error("This should never happen: CM object with dispatcherPath=\"", this.dispatcherName, " is not a dispatcher.");
            this.removeDispatchers(resultList);
            return null;
        }
        return this.checkForNewName(res);
    }

    private String checkForNewName(CMClass res) throws CommandExecutionException {
        String defaultName;
        String searchPath = this.getPropertyValue(res, "searchPath");
        if (searchPath == null) {
            return null;
        }
        String dispPath = this.getPropertyValue(res, "dispatcherPath");
        String newDefaultName = defaultName = this.getPropertyValue(res, "defaultName");
        if (this.isSymbolicNameDefined()) {
            newDefaultName = this.symbolicName;
        } else if (this.defaultNameHasNotBeenChanged(defaultName, dispPath)) {
            newDefaultName = this.dispatcherName;
        }
        if (this.hasNotChanged(dispPath, defaultName, newDefaultName)) {
            this.extractDispatcherID(res);
        } else {
            cat.info("Dispatcher name has been changed.  Updating path from ", dispPath, " to ", this.dispatcherName, " and defaultName from ", defaultName, " to ", newDefaultName);
            searchPath = this.renameDispatcher(this.dispatcherName, searchPath, newDefaultName);
        }
        return searchPath;
    }

    private String getPropertyValue(CMClass res, String propertyName) {
        Node propertyNode = res.getPropertyAsElement(propertyName).selectSingleNode("//" + propertyName + "/value");
        return propertyNode == null ? null : propertyNode.getText();
    }

    private boolean isSymbolicNameDefined() {
        return StringUtils.isNotEmpty((String)this.symbolicName);
    }

    private boolean defaultNameHasNotBeenChanged(String defaultName, String dispPath) {
        return defaultName.equalsIgnoreCase(dispPath);
    }

    private boolean hasNotChanged(String dispPath, String defaultName, String newDefaultName) {
        return dispPath.equalsIgnoreCase(this.dispatcherName) && this.defaultNameHasNotBeenChanged(newDefaultName, defaultName);
    }

    private String renameDispatcher(String path, String searchPath, String newDefaultName) throws CommandExecutionException {
        ContentManagerUpdateCommand update = new ContentManagerUpdateCommand();
        update.addObject("dispatcher");
        update.setSearchPath(searchPath);
        update.setDispatcherPath(path);
        update.setDefaultName(newDefaultName);
        update.setRunningState(this.runningState);
        update.addRequestedProperty("dispatcherID");
        update.addRequestedProperty("searchPath");
        update.setDoTrustedRequest(true);
        update.execute();
        this.runningStateChange = false;
        Element responseElement = update.getUpdateResponse();
        this.setGuid(responseElement);
        Element value = (Element)responseElement.selectSingleNode("//searchPath/value");
        if (value == null) {
            return null;
        }
        return value.getTextTrim();
    }

    void updateDispatcherRunningState(String searchPath) throws CommandExecutionException {
        ContentManagerUpdateCommand update = new ContentManagerUpdateCommand();
        update.addObject("dispatcher");
        update.setSearchPath(searchPath);
        update.setRunningState(this.runningState);
        update.setEdition(CMBootstrap.getVersion());
        update.setDoTrustedRequest(true);
        update.execute();
        this.runningStateChange = false;
    }

    private void updateEdition(String searchPath) throws CommandExecutionException {
        ContentManagerUpdateCommand update = new ContentManagerUpdateCommand();
        update.addObject("dispatcher");
        update.setSearchPath(searchPath);
        update.setEdition(CMBootstrap.getVersion());
        update.setDoTrustedRequest(true);
        update.execute();
    }

    private List<CMClass> getRegisteredDispatchers() throws CommandExecutionException {
        ContentManagerQueryCommand query = new ContentManagerQueryCommand(this.getCMSearchPathForRegisteredDispatchers());
        query.addQueryPropertyName("searchPath");
        query.addQueryPropertyName("dispatcherPath");
        query.addQueryPropertyName("dispatcherID");
        query.addQueryPropertyName("runningState");
        query.addQueryPropertyName("defaultName");
        query.addQueryPropertyName("edition");
        query.setDoTrustedRequest(true);
        query.execute();
        List<CMClass> resultList = query.getResultList();
        return resultList;
    }

    protected String getCMSearchPathForRegisteredDispatchers() {
        String dispatcherHostPort = this.dispatcherName.substring(this.dispatcherName.indexOf("//"));
        String dispatcherOldName = dispatcherHostPort.substring(0, dispatcherHostPort.indexOf(47, 2));
        StringBuffer cmSearchBuffer = new StringBuffer("/configuration/descendant::dispatcher[");
        this.buildCMSearchPath(dispatcherHostPort, dispatcherOldName, cmSearchBuffer);
        cmSearchBuffer.append("]");
        cat.debug("Querying CM with searchBuffer = ", cmSearchBuffer);
        return cmSearchBuffer.toString();
    }

    private void buildCMSearchPath(String dispatcherHostPort, String dispatcherOldName, StringBuffer searchBuffer) {
        try {
            this.appendSymbolicName(searchBuffer);
            InetAddress inet = InetAddress.getLocalHost();
            String dispatcherHostPortEnd = dispatcherHostPort.substring(dispatcherHostPort.indexOf(58));
            String dispatcherOldNameEnd = dispatcherOldName.substring(dispatcherOldName.indexOf(58));
            this.appendNewOldHostNames("//" + inet.getHostName() + dispatcherHostPortEnd, "//" + inet.getHostName() + dispatcherOldNameEnd, searchBuffer);
            searchBuffer.append(" or ");
            this.appendNewOldHostNames("//" + inet.getCanonicalHostName() + dispatcherHostPortEnd, "//" + inet.getCanonicalHostName() + dispatcherOldNameEnd, searchBuffer);
            searchBuffer.append(" or ");
            this.appendNewOldHostNames("//" + inet.getHostAddress() + dispatcherHostPortEnd, "//" + inet.getHostAddress() + dispatcherOldNameEnd, searchBuffer);
            searchBuffer.append(" or ");
            this.appendNewOldHostNames(dispatcherHostPort, dispatcherOldName, searchBuffer);
        }
        catch (UnknownHostException e) {
            this.appendNewOldHostNames(dispatcherHostPort, dispatcherOldName, searchBuffer);
        }
    }

    private void appendSymbolicName(StringBuffer searchBuffer) {
        if (this.isSymbolicNameDefined()) {
            searchBuffer.append("@defaultName = '");
            searchBuffer.append(this.symbolicName + "' or ");
        }
    }

    private void appendNewOldHostNames(String hostName, String oldHostName, StringBuffer searchBuffer) {
        searchBuffer.append("ends-with(@dispatcherPath, '");
        searchBuffer.append(hostName + "')");
        searchBuffer.append(" or ends-with(@dispatcherPath, '");
        searchBuffer.append(oldHostName + "')");
    }

    private void removeDispatchers(List<CMClass> resultList) throws CommandExecutionException {
        ContentManagerDeleteCommand cmd = new ContentManagerDeleteCommand();
        cmd.setForce(true);
        cmd.setRecursive(true);
        for (CMClass res : resultList) {
            Element elem = res.getPropertyAsElement("searchPath").element("value");
            if (elem == null) continue;
            String path = elem.getTextTrim();
            cmd.addObject("dispatcher");
            cmd.setSearchPath(path);
        }
        try {
            cmd.setDoTrustedRequest(true);
            cmd.execute();
        }
        catch (CommandExecutionException e) {
            throw new CommandExecutionException(e, "trouble deleting extra dispatchers from CM" + e.getMessage());
        }
    }

    private String addDispatcher(String objectName) throws CommandExecutionException {
        ContentManagerAddCommand addCmd = new ContentManagerAddCommand();
        addCmd.setSearch("/configuration");
        addCmd.addObject("dispatcher");
        addCmd.setDefaultName(this.isSymbolicNameDefined() ? this.symbolicName : objectName);
        addCmd.setDispatcherPath(objectName);
        addCmd.setRunningState(this.runningState);
        addCmd.setUpdateAction("update");
        addCmd.setEdition(CMBootstrap.getVersion());
        this.setInitDispatcherProperties(addCmd);
        addCmd.addRequestedProperty("dispatcherID");
        addCmd.addRequestedProperty("searchPath");
        addCmd.setDoTrustedRequest(true);
        addCmd.execute();
        this.extractDispatcherId(addCmd);
        return addCmd.getResponseSearchPath();
    }

    private void setInitDispatcherProperties(ContentManagerAddCommand addCmd) {
        String sgString = System.getProperty(DISP_PROP_SERVERGROUP, "");
        if (StringUtils.isNotBlank((String)sgString)) {
            cat.info("System property 'com.ibm.cognos.pogo.dispatcher.servergroup' is set. Set server group to '" + sgString + "' when adding dispatcher ", this.dispatcherName, " to CM.");
            addCmd.setServerGroup(sgString);
        } else {
            sgString = PropertyInserter.getProperty(DISP_PROP_SERVERGROUP);
            if (StringUtils.isNotBlank((String)sgString)) {
                cat.info("WEB-INF/Properties file is set with property 'com.ibm.cognos.pogo.dispatcher.servergroup'. Set server group to '" + sgString + "' when adding dispatcher ", this.dispatcherName, " to CM.");
                addCmd.setServerGroup(sgString);
            } else {
                cat.debug("Property 'com.ibm.cognos.pogo.dispatcher.servergroup' is not set via System property or WEB-INF/Properties, server group is not set.");
            }
        }
    }

    static String getVersion() {
        String version = Version.getVersionStr();
        return version.length() < 20 ? version : version.substring(version.length() - 20);
    }

    private void extractDispatcherID(CMClass res) {
        Element responseElement = res.getPropertyAsElement("dispatcherID");
        this.setGuid(responseElement);
    }

    private void extractDispatcherId(ContentManagerAddCommand addCmd) {
        Element responseElement = addCmd.getAddResponse();
        this.setGuid(responseElement);
    }

    private void setGuid(Element responseElement) {
        Element dispatcherIdElement = (Element)responseElement.selectSingleNode("//dispatcherID/value");
        this.dispatcherGUID = dispatcherIdElement.getTextTrim();
    }

    private void updateAllServices(String dispatcherPath) throws CommandExecutionException {
        HashMap<String, Service> servicesToAdd = this.createServiceMapFromServiceFiles();
        Set<String> installedComponentsToAdd = this.pogoEngine.getInstalledComponents();
        List<CMClass> matches = this.getServiceAndComponentListFromCM(dispatcherPath);
        ServiceSynchronizer synchronizer = new ServiceSynchronizer(servicesToAdd, installedComponentsToAdd, matches);
        synchronizer.removeStaleServicesFromCM(dispatcherPath);
        synchronizer.updateCMDefaultNames(dispatcherPath);
        synchronizer.addServicesAndInstalledComponents(dispatcherPath);
    }

    List<CMClass> getServiceAndComponentListFromCM(String dispatcherPath) throws CommandExecutionException {
        ContentManagerQueryCommand query = new ContentManagerQueryCommand(dispatcherPath + "/*");
        query.addQueryPropertyName("objectClass");
        query.addQueryPropertyName("componentID");
        query.setDoTrustedRequest(true);
        query.execute();
        return query.getResultList();
    }

    private HashMap<String, Service> createServiceMapFromServiceFiles() {
        HashMap<String, Service> map = new HashMap<String, Service>();
        DispatcherServices dispatcherServices = this.pogoEngine.getDispatcherServices();
        for (Service service : dispatcherServices.getBootstrapServices()) {
            map.put(service.getName(), service);
        }
        return map;
    }

    String getDispatcherName() {
        return this.dispatcherName;
    }
}

