/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.coordinator;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.config.ConfigurationImpl;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.config.DispatcherListService;
import com.cognos.pogo.contentmanager.coordinator.ConfigurationCMQuery;
import com.cognos.pogo.contentmanager.coordinator.PeakTimeChecker;
import com.cognos.pogo.contentmanager.coordinator.RefreshControllerReconfigureInterface;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class RefreshController
implements RefreshControllerReconfigureInterface {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(RefreshController.class.getName());
    private PogoEngine pogoEngine;
    private boolean firstTime = true;
    private ConfigurationImpl configuration = new ConfigurationImpl();
    private Element queryResultElement;
    private Element cmValueElement;
    private Element cmItemElement;
    private ConfigurationCMQuery configurationCMQuery;
    private PeakTimeChecker peakTimeChecker;

    public RefreshController(String dispatcherName, PogoEngine engine) {
        this.pogoEngine = engine;
        this.configurationCMQuery = new ConfigurationCMQuery(this.pogoEngine, dispatcherName);
        this.inititalizeCmElements();
        this.peakTimeChecker = new PeakTimeChecker(this, this.configuration);
    }

    private void inititalizeCmElements() {
        this.queryResultElement = DocumentHelper.createElement((String)"queryResult");
        this.cmItemElement = this.queryResultElement.addElement("item");
        Element name = this.cmItemElement.addElement("contentManager");
        this.cmValueElement = name.addElement("value");
        this.cmValueElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
    }

    public void run() throws Exception {
        if (this.configurationCMQuery.queryCM(this.configuration)) {
            this.addActiveCmToConfiguration();
            this.parseInstalledComponents();
            if (this.firstTime) {
                this.firstTime = false;
                this.composeAndConfigureServices();
            } else {
                this.reconfigureServices();
            }
        }
    }

    private void addActiveCmToConfiguration() {
        String activeCM = NodeIdGuidMapper.getContentManagerNID().getURI();
        this.cmValueElement.setText(activeCM);
        try {
            this.configuration.getICCLConfiguration().init(this.queryResultElement);
        }
        catch (CCLConfigurationException e) {
            cat.error("ICCLConfiguration blew up.", (Throwable)e);
        }
        Element cmResp = this.configuration.getCmResponse(null);
        Node cmNode = cmResp.selectSingleNode("//item/contentManager/value");
        if (cmNode == null) {
            Element cmItemDuplicate = this.cmItemElement.createCopy();
            cmResp.add(cmItemDuplicate);
        } else {
            cmNode.setText(activeCM);
        }
    }

    public boolean checkTime(String newTime) {
        return this.configurationCMQuery.checkTime(newTime);
    }

    private void composeAndConfigureServices() {
        this.peakTimeChecker.addInPeakToConfig();
        this.pogoEngine.getDispatcherServices().compose(this.pogoEngine);
        this.pogoEngine.getDispatcherServices().configure(this.configuration);
        this.peakTimeChecker.createPeakTimers();
    }

    private void reconfigureServices() {
        this.peakTimeChecker.checkPeakTimes();
        this.reconfigureAllServices();
    }

    @Override
    public void reconfigureAllServices() {
        this.pogoEngine.getDispatcherServices().reconfigure(this.configuration);
    }

    private void parseInstalledComponents() {
        HashMap installedMap = new HashMap();
        HashSet<String> completeComponents = new HashSet<String>();
        DispatcherList dispatcherList = (DispatcherList)this.configuration.getDispatcherList();
        Iterator<DispatcherListElement> iter = dispatcherList.getAllDispatcherListElements();
        while (iter.hasNext()) {
            DispatcherListElement dle = iter.next();
            String dispatcherName = dle.getName();
            HashSet<String> installedList = new HashSet<String>();
            Iterator<DispatcherListService> iterator = dle.iterator();
            while (iterator.hasNext()) {
                DispatcherListService service = iterator.next();
                if (!service.getName().equals("installedComponent")) continue;
                installedList.add(service.getComponentID());
                completeComponents.add(service.getComponentID());
            }
            if (installedList.size() <= 0) continue;
            installedMap.put(dispatcherName, installedList);
        }
        if (PogoMBeanServer.isNoJMX()) {
            completeComponents.add("noJMX");
        }
        installedMap.put("system", completeComponents);
        this.pogoEngine.getContext().setAttribute("com.cognos.pogo.InstalledComponents", installedMap);
    }

    public boolean isUnregisteredDispatcher() {
        return this.configurationCMQuery.isNoDispatcher();
    }
}

