/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.coordinator;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.contentmanager.coordinator.ActiveCMChecker;
import com.cognos.pogo.contentmanager.coordinator.ActiveCMControl;
import com.cognos.pogo.contentmanager.coordinator.ActiveCmFinder;
import com.cognos.pogo.contentmanager.coordinator.BootstrapConfigurePublish;
import com.cognos.pogo.contentmanager.coordinator.BootstrapConfigurePublishInt;
import com.cognos.pogo.contentmanager.coordinator.CMBootstrap;
import com.cognos.pogo.contentmanager.coordinator.CMChangeObserver;
import com.cognos.pogo.contentmanager.coordinator.CMUri;
import com.cognos.pogo.handlers.regulate.Stopper;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.logging.Slogger;
import com.cognos.pogo.logging.messages.ServiceErrorAuditMsg;
import com.cognos.pogo.monitoring.impl.RuntimeInfoPublisherImpl;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.reportservice.AdvancedSettingsConfigurationChange;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class RuntimeInfoPublishHandler
extends BasicHandler
implements CMChangeObserver {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(RuntimeInfoPublishHandler.class.getName());
    private static final LoggingRealm loggingRealm = LoggingRealmFactory.getInstance("DISP");
    private static final Slogger slogger = loggingRealm.getLogger(CMBootstrap.class.getName());
    private static final String SYSTEM_SERVICE = "systemService";
    private static final int DEFAULT_RUNTIME_UPDATE_INTERVAL = 0;
    private static final int DEFAULT_RUNTIME_UPDATE_INTERVAL_NO_JMX = 30000;
    private static final int DEFAULT_CONFIGURATION_POLLING_INTERVAL = 30000;
    private BootstrapConfigurePublishInt bcp;
    private RuntimeInfoPublisherImpl rtiPublisher;
    private ActiveCMChecker activeCMChecker;
    protected int cmHeartbeatIntervalInMillis = 5000;
    private int runtimeInfoUpdateInterval = 0;
    private int configurationPollingInterval = 30000;
    private boolean configurationStarted = false;
    private CMUri cmUri = new CMUri();

    public RuntimeInfoPublishHandler() {
        super(cat);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        String publisherName = this.getRequiredAttribute(cat, "publisherName");
        this.createRtiPublish(engine, publisherName);
        this.bcp = new BootstrapConfigurePublish(engine, publisherName);
        ActiveCMControl.getInstance().setLocalCMNode((NodeID)engine.getContextAttribute("localCmNodeId"));
        ActiveCMControl.getInstance().addObserver(this);
        this.setControlInterval();
        this.setCmheartbeat();
    }

    @Override
    public void configure(Configuration configuration) {
        this.rtiPublisher.setDispatcherSearchPath(configuration.getLocalSearchPath());
        this.extractUpdateIntervalsFromAdvancedSettings(configuration);
        this.bcp.setCheckingInterval(this.configurationPollingInterval);
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
        this.rtiPublisher.updateInterval(this.runtimeInfoUpdateInterval);
    }

    @Override
    public void start() {
        ActiveCmFinder cmFinder = new ActiveCmFinder();
        cat.debug("Start: finding active CM");
        String activecm = cmFinder.findActiveCM();
        if (activecm != null) {
            this.cmUri.checkActiveCMChanged(activecm);
            this.startConfiguration(activecm);
        } else {
            cat.debug("rtiPubHandler no active CM yet.");
            this.generateNoCmYetError();
            ActiveCMControl.getInstance().startupFindCM();
        }
        cat.debug("rtiPubHandler finished");
    }

    @Override
    public void allServicesStarted() {
        this.startRTIPub();
        this.publishRunningState();
    }

    @Override
    public void stop() {
        this.stopAciveCMChecking();
        this.stopConfiguration();
    }

    @Override
    public boolean notifyCMChange(String newCmUri) {
        cat.debug("Notify CM change in runtimeInfoPublishHandler called");
        this.updateCmUri(newCmUri);
        boolean cmChanged = this.cmUri.checkActiveCMChanged(newCmUri);
        this.startConfiguration(newCmUri);
        if (cmChanged) {
            this.bcp.changeCM();
            return this.publishRunningState();
        }
        this.unblockRequests();
        return true;
    }

    void updateCmUri(String newCmUri) {
        if (this.activeCMChecker != null) {
            this.activeCMChecker.updateCmUri(newCmUri);
        }
    }

    private void unblockRequests() {
        Stopper.getInstance().unplug();
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        cat.info("unexpected invoke");
    }

    private void createRtiPublish(PogoEngine engine, String publisherName) {
        this.rtiPublisher = new RuntimeInfoPublisherImpl();
        engine.getContext().setAttribute(publisherName, this.rtiPublisher);
    }

    private void setCmheartbeat() {
        try {
            String sCmHeartbeatInSecs = this.getRequiredAttribute(cat, "cmHeartbeatSec");
            if (sCmHeartbeatInSecs != null && sCmHeartbeatInSecs.length() > 0) {
                this.cmHeartbeatIntervalInMillis = Integer.parseInt(sCmHeartbeatInSecs) * 1000;
            }
        }
        catch (Exception x) {
            cat.error("problem configuring runtime info publisher, cannot parse cm heartbeat interval. Default used", (Throwable)x);
        }
    }

    private void setControlInterval() {
        int newInterval = 0;
        try {
            String sPubInterval = this.getRequiredAttribute(cat, "publishIntervalSec");
            if (sPubInterval != null && sPubInterval.length() > 0) {
                newInterval = Integer.parseInt(sPubInterval);
            }
        }
        catch (Exception x) {
            cat.error("problem configuring runtime info publisher, cannot parse publish interval.  Publishing is disabled.", (Throwable)x);
            newInterval = 0;
        }
        ActiveCMControl.getInstance().setTimeout(newInterval);
    }

    private void extractUpdateIntervalsFromAdvancedSettings(Configuration configuration) {
        this.getCorrectAdvancedSettings(configuration);
        AdvancedSettingsConfigurationChange configurationChange = new AdvancedSettingsConfigurationChange();
        configurationChange.check(configuration);
        this.getUpdateInterval(configurationChange);
        this.getPollingInterval(configurationChange);
    }

    private void getUpdateInterval(AdvancedSettingsConfigurationChange configurationChange) {
        int defaultRuntimeUpdateInterval = PogoMBeanServer.isNoJMX() ? 30000 : 0;
        this.runtimeInfoUpdateInterval = this.getInterval(configurationChange, "DISP.RuntimeInfoUpdateInterval", defaultRuntimeUpdateInterval);
    }

    private void getPollingInterval(AdvancedSettingsConfigurationChange configurationChange) {
        this.configurationPollingInterval = this.getInterval(configurationChange, "DISP.ConfigurationPollingInterval", 30000);
    }

    private int getInterval(AdvancedSettingsConfigurationChange configurationChange, String attributeName, int defaultInterval) {
        int interval;
        String intervalStr = configurationChange.getAdvancedSettingsValue(attributeName);
        if (intervalStr != null) {
            try {
                interval = Integer.parseInt(intervalStr) * 1000;
            }
            catch (NumberFormatException e) {
                cat.warn("Unable to parse " + attributeName + ": " + intervalStr);
                interval = defaultInterval;
            }
        } else {
            interval = defaultInterval;
        }
        return interval;
    }

    private void getCorrectAdvancedSettings(Configuration configuration) {
        configuration.reconfigureForService(SYSTEM_SERVICE);
    }

    private void startConfiguration(String activeCmUri) {
        if (!this.configurationStarted) {
            this.configurationStarted = true;
            this.bcp.start();
            this.startCheckingCM(activeCmUri);
        }
    }

    void startCheckingCM(String activeCmUri) {
        try {
            this.activeCMChecker = this.createActiveCMChecker(activeCmUri);
            this.activeCMChecker.startChecking();
        }
        catch (Exception e) {
            cat.error("Unable to check for Active CM ", (Throwable)e);
        }
    }

    protected ActiveCMChecker createActiveCMChecker(String activeCmUri) throws Exception {
        return new ActiveCMChecker(this.cmHeartbeatIntervalInMillis, activeCmUri);
    }

    private void stopConfiguration() {
        if (this.configurationStarted) {
            this.configurationStarted = false;
            this.bcp.stop();
        }
    }

    private void stopAciveCMChecking() {
        if (this.activeCMChecker != null) {
            this.activeCMChecker.stopChecking();
        }
    }

    ActiveCMChecker getActiveCMChecker() {
        return this.activeCMChecker;
    }

    private void startRTIPub() {
        this.rtiPublisher.createRunTimeInfoObjects();
        this.rtiPublisher.updateInterval(this.runtimeInfoUpdateInterval);
    }

    private boolean publishRunningState() {
        boolean publishRunningState = this.rtiPublisher.publishRunningStates();
        if (!publishRunningState) {
            this.cmUri.resetCMChanged();
        }
        return publishRunningState;
    }

    private void generateNoCmYetError() {
        if (slogger.isEnabledFor(ServiceErrorAuditMsg.levelOf())) {
            ServiceErrorAuditMsg msg = new ServiceErrorAuditMsg("ContentManager", "getActiveContentManager");
            String errorMsg = DispatcherStrings.getInstance().getString("NO_ACTIVE_CM");
            msg.addErrorMessage(errorMsg);
            slogger.log(msg);
        }
    }

    void setRtiPublisherForTesting(RuntimeInfoPublisherImpl publisher) {
        this.rtiPublisher = publisher;
    }

    void setBootstrapConfigurePublishForTesting(BootstrapConfigurePublishInt bcp) {
        this.bcp = bcp;
    }
}

