/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.service;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerDeleteCommand;
import com.cognos.pogo.util.PogoLogger;

public class ContentManagerDeleteService {
    private static final PogoLogger log = PogoLogger.getLogger();
    private String serviceName;
    private ContentManagerDeleteCommand deleteCommand;
    private String dispatcherPath;

    public ContentManagerDeleteService(String serviceName, ContentManagerDeleteCommand deleteCommand) {
        this.serviceName = serviceName;
        this.deleteCommand = deleteCommand;
    }

    public ContentManagerDeleteService(String serviceName) {
        this(serviceName, new ContentManagerDeleteCommand());
    }

    public void execute() {
        this.deleteInstalledComponent();
        this.deleteService();
        this.executeDeleteCommand();
    }

    private void deleteInstalledComponent() {
        log.info("Removing installedComponent of type: ", this.serviceName);
        this.deleteCommand.addObject("installedComponent");
        String searchPath = this.dispatcherPath + "/installedComponent[@defaultName='installedComponent" + this.serviceName + "']";
        this.deleteCommand.setSearchPath(searchPath);
    }

    private void deleteService() {
        this.deleteCommand.addObject(this.serviceName);
        this.deleteCommand.setSearchPath(this.dispatcherPath + "/" + this.serviceName);
    }

    private void executeDeleteCommand() {
        log.info("Deleting service object ", this.serviceName);
        this.deleteCommand.setDoTrustedRequest(true);
        try {
            this.deleteCommand.execute();
        }
        catch (CommandExecutionException e) {
            log.error("Unable to delete service ", this.serviceName, e);
        }
    }

    public void setDispatcherPath(String dispatcherPath) {
        this.dispatcherPath = dispatcherPath;
    }
}

