/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.devtool;

import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.performance.servlet.PerformanceIndicatorWrappedServlet;
import com.cognos.pogo.util.Version;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MemDiagServlet
extends PerformanceIndicatorWrappedServlet {
    private static final long serialVersionUID = -2207447131434368624L;
    private ServletContext context;
    private PogoEngine pogo_engine;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = config.getServletContext();
    }

    private synchronized PogoEngine getPogoEngine() {
        if (this.pogo_engine == null) {
            this.pogo_engine = (PogoEngine)this.context.getAttribute("com.cognos.pogo.thePogoEngine");
        }
        return this.pogo_engine;
    }

    public void destroy() {
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String reason;
        int status;
        boolean ready;
        response.setContentType("text/html");
        PogoEngine engine = this.getPogoEngine();
        boolean bl = ready = engine != null && engine.getReadyToProcess();
        if (ready) {
            status = 200;
            reason = "Dispatcher is ready.";
        } else if (this.allCMsDown()) {
            status = 403;
            reason = "All CMs are unavailable.";
        } else {
            status = 503;
            reason = "Dispatcher is not ready.";
        }
        response.setStatus(status);
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Cognos P2PD dispatcher</title>");
        out.println("</head>");
        out.println("<body>");
        out.println("version: " + Version.getVersionStr());
        out.println(reason);
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    private boolean allCMsDown() {
        boolean result = true;
        for (NodeID cmNode : NodeIdGuidMapper.getInstance().getCmUrlList()) {
            String cmStatus = cmNode.getCmStatus();
            if (cmStatus != null && cmStatus.equals("cmStartFailed")) continue;
            result = false;
        }
        return result;
    }
}

