/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.caf;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.CAFHandler;
import com.cognos.pogo.pdk.CAFRuntimeException;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class CAFSecureFlagHandler
extends BasicHandler {
    private PogoEngine pogoEngine;
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(CAFSecureFlagHandler.class.getName());

    public CAFSecureFlagHandler() {
        super(cat);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if ("true".equals(mc.getProperty("soapActionIsNotSupportedLocally"))) {
            cat.debug("invokeImpl: Skipping CAF because soapActionIsNotSupportedLocally");
            return;
        }
        if (this.ifSealOfApprovalSetTrue(mc) || this.ifClonedPassportRequest(mc)) {
            cat.debug("we've seen the request already or is a clonePassport request, so just do cleanup");
            this.cleanupCAFSecureFlag(mc);
        } else {
            Boolean certified = this.processRequest(mc);
            mc.setProperty("caf.sealOfApprovalSet", certified);
            if (certified.booleanValue()) {
                mc.addPreRespondHook(this);
            }
        }
    }

    private Boolean processRequest(MessageContext mc) {
        if ("true".equals(mc.getProperty("soapActionIsNotSupportedLocally"))) {
            cat.debug("processRequest: Skipping CAF because soapActionIsNotSupportedLocally");
            return Boolean.FALSE;
        }
        CAFHandler cafHandler = (CAFHandler)mc.getProperty("caf.CAFHandler");
        if (cafHandler == null) {
            cat.debug("cafHandler is not set in MessageContext, do nothing.");
            return Boolean.FALSE;
        }
        String sealOfApproval = null;
        try {
            sealOfApproval = cafHandler.getSecureState();
        }
        catch (CAFRuntimeException ex) {
            mc.setFault(new Fault("CAF_ERRPAGE_CONTACTADMIN", ex));
            return Boolean.FALSE;
        }
        if (sealOfApproval == null) {
            cat.debug("No CAF seal of approval available.");
            return Boolean.FALSE;
        }
        Object o = mc.getProperty("request.envelope");
        if (o == null || !(o instanceof BIBusEnvelope)) {
            cat.debug("No request envelope found, or envelope is not instance of BIBusEnvelope, this should never happen.");
            return Boolean.FALSE;
        }
        Boolean balancedRequest = (Boolean)mc.getProperty("balancedRequest");
        BIBusEnvelope env = (BIBusEnvelope)o;
        if (cafHandler.getExternal()) {
            env.setCAFSecureState(sealOfApproval);
        } else if (!balancedRequest.booleanValue()) {
            env.setCAFSecureState(null);
        }
        return Boolean.TRUE;
    }

    @Override
    public void configure(Configuration configuration) {
        this.pogoEngine.getContext().setAttribute("caf.CAFFactory", new Object());
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.pogoEngine = engine;
    }

    private boolean ifSealOfApprovalSetTrue(MessageContext mc) {
        Boolean sealOfApproval = (Boolean)mc.getProperty("caf.sealOfApprovalSet");
        return sealOfApproval != null && sealOfApproval != false;
    }

    protected boolean ifClonedPassportRequest(MessageContext mc) {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        if (requestEnvelope == null) {
            cat.debug("NULL request envelope; nothing to do in CAFResetSecureFlagHandler");
            return false;
        }
        return this.isClonePassportRequest(requestEnvelope.getCAMAction());
    }

    protected void cleanupCAFSecureFlag(MessageContext mc) {
        Object o = mc.getProperty("response.envelope");
        if (o != null && o instanceof BIBusEnvelope) {
            ((BIBusEnvelope)o).setCAFSecureState(null);
        } else if (o == null) {
            cat.warn("should remove cafSecureFlag, but response is null.");
        } else {
            cat.warn("should remove cafSecureFlag, but response is not an instance of BIBusEnvelope: " + o.getClass().getName());
        }
    }

    private boolean isClonePassportRequest(String camAction) {
        return "clonePassport".equals(camAction);
    }
}

