/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.configurable;

import com.cognos.pogo.config.AdminCommand;
import com.cognos.pogo.config.NotifyAdminCommand;
import com.cognos.pogo.config.PingAdminCommand;
import com.cognos.pogo.config.PingV1AdminCommand;
import com.cognos.pogo.config.StartServiceAdminCommand;
import com.cognos.pogo.config.StartServiceV1AdminCommand;
import com.cognos.pogo.config.StopServiceAdminCommand;
import com.cognos.pogo.config.StopServiceV1AdminCommand;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class AdminRequestHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(AdminRequestHandler.class.getName());
    private static final String ping_request = "ping";
    private static final String start_service_request = "startService";
    private static final String stop_service_request = "stopService";
    private static final String notify_request = "notify";
    private Configuration configuration;
    private PogoEngine pogoEngine;

    public AdminRequestHandler() {
        super(cat);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.pogoEngine = engine;
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        AdminCommand command;
        SOAPEnvelope env = (SOAPEnvelope)mc.getProperty("request.envelope");
        Element soapBody = env.getBody();
        Element cmd = null;
        String soapAction = mc.getStrProperty("request.soapaction");
        boolean v1 = soapAction.equals("http://developer.cognos.com/schemas/dispatcher/1");
        cat.debug(env.getBody().asXML());
        cmd = soapBody.element(ping_request);
        if (cmd != null) {
            if (v1) {
                cat.debug("got ping v1 request");
                command = new PingV1AdminCommand(cmd, mc);
            } else {
                cat.debug("got ping request");
                command = new PingAdminCommand(cmd, mc);
            }
        } else {
            cmd = soapBody.element(start_service_request);
            if (cmd != null) {
                if (v1) {
                    cat.debug("got start service request");
                    command = new StartServiceV1AdminCommand(cmd, mc, this.pogoEngine);
                } else {
                    cat.debug("got start service request");
                    command = new StartServiceAdminCommand(cmd, mc, this.pogoEngine);
                }
            } else {
                cmd = soapBody.element(stop_service_request);
                if (cmd != null) {
                    if (v1) {
                        cat.debug("got stop service request");
                        command = new StopServiceV1AdminCommand(cmd, mc, this.pogoEngine);
                    } else {
                        cat.debug("got stop service request");
                        command = new StopServiceAdminCommand(cmd, mc, this.pogoEngine);
                    }
                } else {
                    cmd = soapBody.element(notify_request);
                    if (cmd != null) {
                        cat.debug("got notify service request");
                        command = new NotifyAdminCommand(cmd, mc, this.pogoEngine, this.configuration);
                    } else {
                        cat.error("Unknown request...");
                        throw new PogoException("Unknown Command");
                    }
                }
            }
        }
        command.execute();
        cat.debug("MessageContext = " + mc);
    }

    @Override
    public void configure(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configuration = configuration;
    }
}

