/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.configurable;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.config.DispatcherNameParser;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.StandaloneServerConnection;
import java.net.InetAddress;
import org.dom4j.Element;

public class HandoffAdminCommand
extends BIBusCommand {
    private String host;
    private int port;
    private boolean ssl;
    private String requestContext;
    private Element commandElement;
    private Element responseElement;
    private final String soapAction;

    public HandoffAdminCommand(Element newCommandElement, DispatcherNameParser nameParser, String soapAction) throws CommandExecutionException {
        this.commandElement = newCommandElement.createCopy();
        try {
            this.host = nameParser.getHost();
            this.port = nameParser.getPort();
            this.ssl = nameParser.getSsl();
            this.requestContext = nameParser.getRequestPath();
            InetAddress.getByName(this.host);
        }
        catch (Exception ex) {
            throw new CommandExecutionException(ex, ex.getMessage());
        }
        this.soapAction = soapAction;
    }

    public HandoffAdminCommand(Element newCommandElement, NodeID dispatcherNodeId, String soapAction) {
        this.commandElement = newCommandElement.createCopy();
        this.host = dispatcherNodeId.getHost();
        this.port = dispatcherNodeId.getPort();
        this.ssl = dispatcherNodeId.getProtocol().equals("https");
        this.requestContext = dispatcherNodeId.getPath();
        this.soapAction = soapAction;
    }

    @Override
    protected ServerConnection fetchServerConnection() {
        return new StandaloneServerConnection(this.host, this.port, this.ssl);
    }

    @Override
    protected String fetchRequestContext() {
        return this.requestContext;
    }

    @Override
    protected void executeImpl(Element requestElement) throws CommandExecutionException {
        requestElement.add(this.commandElement);
    }

    @Override
    protected void handleResponseImpl(Element responseElement) throws CommandExecutionException {
        this.responseElement = responseElement;
    }

    public Element getResponseElement() {
        return this.responseElement;
    }

    @Override
    protected void addExtraHTTPHeaders(ServerConnection connection) {
        connection.addRequestHeader("SOAPAction", this.soapAction);
    }
}

