/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.contentmanager;

import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.contentmanager.ContentManagerMultipleQueryCommand;
import com.cognos.pogo.handlers.contentmanager.GetDataProcessor;
import com.cognos.pogo.impl.PogoSOAPAttachmentResponder;
import com.cognos.pogo.impl.PogoSOAPMessageResponder;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.ByteRangeParser;
import com.cognos.pogo.util.CMByteRange;
import java.util.ArrayList;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;
import org.dom4j.QName;

public class ByteRangeHandler
extends BasicHandler {
    private static Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(ByteRangeHandler.class.getName());
    protected static final QName BUS_QUERY = new QName("query", BIBusCommand.BUS_NAMESPACE);

    public ByteRangeHandler() {
        super(category);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        InternetHeaders headers = (InternetHeaders)mc.getProperty("request.headers");
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        String ranges = headers.getHeader("Range", ",");
        if (ranges == null) {
            return;
        }
        ByteRangeParser aParser = new ByteRangeParser();
        ArrayList<CMByteRange> rangeList = aParser.parseRangeHeader(ranges);
        if (rangeList == null || rangeList.size() == 0) {
            GetDataProcessor.makeDummyResponse(mc);
            mc.setProperty("cm.queryCM", Boolean.FALSE);
            return;
        }
        mc.setProperty("byteRanges", Integer.toString(rangeList.size()));
        if (rangeList.size() == 1) {
            this.sendSingleMessage(mc);
        } else {
            this.sendMultipartMessage(mc);
        }
        Element queryElement = this.getQueryElement(envelope);
        if (queryElement == null) {
            return;
        }
        queryElement.detach();
        Element bodyElement = envelope.getBody();
        Element multiQuery = bodyElement.addElement(BUS_QUERY);
        Element validatorElement = queryElement.element("validator");
        if (validatorElement != null) {
            validatorElement.detach();
            multiQuery.add(validatorElement);
        }
        Element requests = ContentManagerMultipleQueryCommand.addRequestsElement(multiQuery);
        for (CMByteRange range : rangeList) {
            Element queryItem = ContentManagerMultipleQueryCommand.pasteQueryItemToElementFromSingleSearch(queryElement, requests);
            Element options = this.addOptionElement(queryItem);
            this.addToQueryOptions(options, range);
        }
    }

    private void sendMultipartMessage(MessageContext mc) {
        mc.setProperty("pogo.responder", new PogoSOAPMessageResponder());
    }

    private void sendSingleMessage(MessageContext mc) {
        mc.setProperty("pogo.responder", new PogoSOAPAttachmentResponder());
    }

    private Element getQueryElement(BIBusEnvelope envelope) {
        Element queryElement = envelope.getBody().element("query");
        if (queryElement == null) {
            return null;
        }
        return queryElement;
    }

    private Element addOptionElement(Element queryElement) {
        Element options = queryElement.element("options");
        if (options == null) {
            options = queryElement.addElement("options");
            options.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":queryOptions");
        }
        return options;
    }

    private void addToQueryOptions(Element options, CMByteRange range) {
        Element schemaInfo = this.addOptionsElement(options, "schemaInfo", SOAPEnvelope.XSD_BOOLEAN);
        schemaInfo.setText("false");
        Element dataEncoding = this.addOptionsElement(options, "dataEncoding", SOAPEnvelope.XSD_DATA_ENCODING_ENUM);
        dataEncoding.setText("MIME");
        Element maxElement = this.addOptionsElement(options, "maxDataBytes", SOAPEnvelope.XSD_INT);
        maxElement.setText(Long.toString(range.maxDataBytes));
        Element skipElement = this.addOptionsElement(options, "skipDataBytes", SOAPEnvelope.XSD_INT);
        skipElement.setText(Long.toString(range.skipDataBytes));
    }

    private Element addOptionsElement(Element options, String elementTag, String type) {
        Element maxElement = options.element(elementTag);
        if (maxElement == null) {
            maxElement = options.addElement(elementTag);
        }
        maxElement.addAttribute(SOAPEnvelope.XSI_TYPE, type);
        return maxElement;
    }
}

