/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.contentmanager;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.bibus.BIBusPassThroughCommand;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.contentmanager.ContentManagerPassThroughCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Cleanable;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MCUtils;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.StringUtils;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class CMHandler
extends BasicHandler {
    private static Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(CMHandler.class.getName());
    private String cleanListName = "cleanup";
    private static String cacheControlValue;

    public CMHandler() {
        super(category);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.cleanListName = this.getRequiredAttribute(category, "cleanup_list");
    }

    private int handleResponseValidator(BIBusEnvelope responseEnvelope, InternetHeaders responseHeaders, int statusCode, MessageContext messageContext) {
        if (statusCode == 500) {
            return statusCode;
        }
        if (responseEnvelope == null) {
            return statusCode;
        }
        Element bodyElement = responseEnvelope.getBody();
        if (bodyElement == null) {
            return statusCode;
        }
        Element queryResponseElement = bodyElement.element("queryResponse");
        if (queryResponseElement == null) {
            return statusCode;
        }
        Element validatorElement = queryResponseElement.element("validator");
        if (validatorElement == null) {
            return statusCode;
        }
        String responseValidator = validatorElement.getText();
        responseHeaders.addHeader("ETag", responseValidator);
        this.addCacheControlHeader(responseHeaders, responseValidator);
        int numberOfRanges = messageContext.getIntProperty("byteRanges", 0);
        String queryValidator = messageContext.getStrProperty("QueryValidator");
        if (!queryValidator.equals(responseValidator)) {
            if (numberOfRanges > 0 && "?".equals(queryValidator)) {
                return 206;
            }
            return 200;
        }
        if (numberOfRanges > 0) {
            return 206;
        }
        return 304;
    }

    private void addCacheControlHeader(InternetHeaders responseHeaders, String responseValidator) {
        if (responseValidator.startsWith("X")) {
            responseHeaders.addHeader("Cache-Control", cacheControlValue);
        }
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        InternetHeaders headers = (InternetHeaders)mc.getProperty("request.headers");
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        Iterator<InputStream> attachmentsIterator = this.getRequestAttachments(mc);
        ContentManagerPassThroughCommand cmCommand = new ContentManagerPassThroughCommand(envelope, headers);
        if (attachmentsIterator != null) {
            cmCommand.setRequestAttachments(attachmentsIterator);
        }
        cmCommand.setAutoRelease(false);
        this.executeCmCommand(mc, cmCommand);
        List<Cleanable> cleanables = MCUtils.getCleanables(mc, this.cleanListName);
        cleanables.add(cmCommand);
    }

    private Iterator<InputStream> getRequestAttachments(MessageContext mc) {
        return (Iterator)mc.getProperty("request.attachments");
    }

    void executeCmCommand(MessageContext mc, BIBusPassThroughCommand cmCommand) {
        try {
            cmCommand.execute();
        }
        catch (SoapFaultException sfex) {
            mc.setFault(new Fault("", cmCommand.getResponseEnvelope()));
        }
        catch (CommandExecutionException ex) {
            category.error("Exception caught while trying to relay a request to CM", (Throwable)ex);
        }
        BIBusEnvelope responseEnvelope = cmCommand.getResponseEnvelope();
        InternetHeaders responseHeaders = cmCommand.getResponseMIMEHeaders();
        int statusCode = this.handleResponseValidator(responseEnvelope, responseHeaders, cmCommand.getStatusCode(), mc);
        mc.setResponseName("response");
        mc.setProperty("response.envelope", responseEnvelope);
        mc.setProperty("response.headers", responseHeaders);
        mc.setProperty("response.status_code", Integer.toString(statusCode));
        Iterator<InputStream> attachments = cmCommand.getAttachments();
        if (attachments.hasNext()) {
            mc.setProperty("response.attachments", attachments);
            mc.setProperty("response.boundary", StringUtils.getUniqueValue());
        } else if (this.shouldSetReportNotFoundFault(mc, statusCode)) {
            mc.setFault(new Fault("CMHandler.reportNotFound"));
        }
    }

    private boolean shouldSetReportNotFoundFault(MessageContext mc, int statusCode) {
        return mc.getProperty("SMEMOutput") != null && statusCode != 304 && !mc.isFaulted();
    }

    static {
        String maxAge = PropertyInserter.getProperty("cache_control_max_age", "3600");
        cacheControlValue = "private, max-age=" + maxAge + ", no-store";
    }
}

