/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.contentmanager;

import com.cognos.pogo.handlers.contentmanager.GetDataProcessor;
import com.cognos.pogo.handlers.contentmanager.GzipGetDataProcessor;
import com.cognos.pogo.handlers.contentmanager.StoreIDGetDataProcessor;
import com.cognos.pogo.handlers.debug.UtilHandlerBase;
import com.cognos.pogo.handlers.errorpage.ErrorPageGenerator;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.performance.listener.PerformanceEventListener;
import com.cognos.pogo.util.PogoLogger;

public class GetDataHandler
extends UtilHandlerBase {
    private static PogoLogger log = PogoLogger.getLogger();

    public GetDataHandler() {
        this(new ErrorPageGenerator());
    }

    public GetDataHandler(ErrorPageGenerator errorPageGenerator) {
        super(log.getNativeLogger(), errorPageGenerator);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        String pathInfo = mc.getStrProperty("path_info");
        mc.setProperty("cm.queryCM", Boolean.TRUE);
        if (pathInfo == null) {
            return;
        }
        boolean isGDI = pathInfo.startsWith("/gdi/");
        boolean isGD = pathInfo.startsWith("/gd/");
        if (!isGDI && !isGD) {
            return;
        }
        if (pathInfo.length() < 5) {
            log.debug("The path info for the 'gd' service is not well formed");
            this.forceNotFoundPage(mc);
            mc.setProperty("cm.queryCM", Boolean.FALSE);
            return;
        }
        BIBusEnvelope requestEnvelope = this.createCMRequest(mc, pathInfo, isGDI);
        if (requestEnvelope == null) {
            return;
        }
        mc.setProperty("contentManagerPassthrough.isGDRequest", Boolean.TRUE);
        log.debug("GetData service constructed the following CM query: ", requestEnvelope);
    }

    private BIBusEnvelope createCMRequest(MessageContext mc, String pathInfo, boolean isGDI) {
        PerformanceEventListener pi = this.getPerformanceIndicator();
        GetDataProcessor processor = isGDI ? new StoreIDGetDataProcessor(pathInfo, mc) : new GzipGetDataProcessor(pathInfo, mc);
        return processor.constructCMRequest(pi);
    }
}

