/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.contentmanager.viewer;

import com.cognos.pogo.handlers.contentmanager.viewer.ReportNameExtractor;
import com.cognos.pogo.handlers.contentmanager.viewer.ServletHeaderSetter;
import com.cognos.pogo.handlers.dispatchercache.StringHeaderBuilder;
import com.cognos.pogo.handlers.util.AdvancedSettingParameterHandler;
import com.cognos.pogo.util.ContentTypeFileExtensions;
import com.cognos.pogo.util.browser.UserAgentType;
import java.util.Date;

public class ContentDispositionCreator {
    private static final String EXCEL_2007_USE_INLINE_PROPERTY = "Excel2007.UseInlineContentDisposition";
    private static final String EXCEL_2007_USE_INLINE_DEFAULT = "false";
    private static final String EXCEL_2007_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    private static final boolean defaultForceAttachment = false;
    private static final ContentTypeFileExtensions defaultContenttypeFileExtensions = new ContentTypeFileExtensions();
    private String contentType;
    private String reportName;
    private DispositionType dispositionType;
    private final ContentTypeFileExtensions contentTypeFileExtensions;

    public ContentDispositionCreator(String contentType, String reportName) {
        this.contentType = contentType;
        this.reportName = reportName;
        this.dispositionType = ContentDispositionCreator.getMimeTypeContentDispositionType(contentType, false);
        this.contentTypeFileExtensions = defaultContenttypeFileExtensions;
    }

    public ContentDispositionCreator(String contentType, String reportName, DispositionType dispositionType) {
        this(contentType, reportName, dispositionType, defaultContenttypeFileExtensions);
    }

    public ContentDispositionCreator(String contentType, String reportName, ContentTypeFileExtensions contentTypeFileExtensions) {
        this(contentType, reportName, contentTypeFileExtensions, false);
    }

    public ContentDispositionCreator(String contentType, String reportName, ContentTypeFileExtensions contentTypeFileExtensions, boolean forceAttachment) {
        this(contentType, reportName, ContentDispositionCreator.getMimeTypeContentDispositionType(contentType, forceAttachment), contentTypeFileExtensions);
    }

    public ContentDispositionCreator(String contentType, String reportName, DispositionType dispositionType, ContentTypeFileExtensions contentTypeFileExtensions) {
        this.contentType = contentType;
        this.reportName = reportName;
        this.dispositionType = dispositionType;
        this.contentTypeFileExtensions = contentTypeFileExtensions;
    }

    public String createContentDisposition(String userAgent) {
        String verifiedReportName = this.verifyReportName();
        UserAgentType userAgentType = UserAgentType.fromUserAgent(userAgent);
        String encodedFilename = userAgentType.getEncodedFilename(verifiedReportName);
        if (this.dispositionType == null) {
            this.dispositionType = this.getDefaultDispositionType();
        }
        StringBuffer strBuf = new StringBuffer(this.dispositionType.toString());
        strBuf.append("; ");
        strBuf.append(encodedFilename);
        return strBuf.toString();
    }

    private String getMimeTypeFileExtension() {
        if (this.contentType != null) {
            return this.contentTypeFileExtensions.getFileExtension(this.parseContentType(this.contentType));
        }
        return null;
    }

    private String parseContentType(String contentType) {
        int indexOfSemiColon = contentType.indexOf(59);
        if (indexOfSemiColon == -1) {
            return contentType;
        }
        return contentType.substring(0, indexOfSemiColon);
    }

    private static final DispositionType getMimeTypeContentDispositionType(String contentType, boolean forceAttachment) {
        boolean useInlineForExcel2007 = Boolean.valueOf(AdvancedSettingParameterHandler.getValue(EXCEL_2007_USE_INLINE_PROPERTY, EXCEL_2007_USE_INLINE_DEFAULT));
        if (ContentDispositionCreator.isExcel2007(contentType) && useInlineForExcel2007) {
            return DispositionType.inline;
        }
        if (ContentDispositionCreator.isExcel2007(contentType) || forceAttachment) {
            return DispositionType.attachment;
        }
        return DispositionType.inline;
    }

    static boolean isExcel(String contentType) {
        return contentType != null && contentType.startsWith("application/vnd.ms-excel");
    }

    static boolean isExcel2007(String contentType) {
        return EXCEL_2007_CONTENT_TYPE.equals(contentType);
    }

    private String verifyReportName() {
        if (this.reportName == null || this.reportName.trim().length() == 0) {
            this.reportName = ReportNameExtractor.dateFormat.format(new Date());
        }
        this.reportName = this.reportName.replaceAll(":", "_");
        StringBuffer sReportName = new StringBuffer(this.reportName);
        String extension = this.getMimeTypeFileExtension();
        if (extension != null) {
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            if (!this.reportName.endsWith(extension)) {
                sReportName.append(extension);
            }
        }
        return sReportName.toString();
    }

    public static void addHeaders(ServletHeaderSetter headerSetter, String contentDisposition) {
        headerSetter.setHeader("Cache-Control", "public");
        headerSetter.setHeader("Content-Disposition", contentDisposition);
    }

    private DispositionType getDefaultDispositionType() {
        return DispositionType.inline;
    }

    public void addHeadersForUserAgent(StringHeaderBuilder headers, String userAgent) {
        String contentDisposition = this.createContentDisposition(userAgent);
        ContentDispositionCreator.addHeaders(headers, contentDisposition);
    }

    public static enum DispositionType {
        inline,
        attachment;

    }
}

