/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.contentmanager.viewer;

import com.cognos.pogo.handlers.contentmanager.viewer.ContentDispositionCreator;
import com.cognos.pogo.handlers.contentmanager.viewer.HttpServletHeader;
import com.cognos.pogo.handlers.contentmanager.viewer.ReportNameExtractor;
import com.cognos.pogo.handlers.contentmanager.viewer.SoapEncodingUtils;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.util.ContentTypeFileExtensions;
import com.cognos.pogo.util.PogoLogger;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Element;

public class SoapEncodingHeaderProcessor {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final BIBusEnvelope envelope;
    private boolean hasHeader = false;
    private String contentDisposition = "";
    private static final ContentTypeFileExtensions defaultContentTypeFileExtensions = new ContentTypeFileExtensions();
    private ContentTypeFileExtensions contentTypeFileExtensions = null;
    private boolean forceAttachmentDisposition;
    private String contentType;
    private String sDownload = "download=";

    public SoapEncodingHeaderProcessor(BIBusEnvelope busEnvelope) {
        this(busEnvelope, defaultContentTypeFileExtensions);
    }

    public SoapEncodingHeaderProcessor(BIBusEnvelope busEnvelope, ContentTypeFileExtensions contentTypeFileExtensions) {
        this.envelope = busEnvelope;
        this.contentTypeFileExtensions = contentTypeFileExtensions;
        this.forceAttachmentDisposition = this.getDownload(busEnvelope);
    }

    protected boolean getDownload(BIBusEnvelope request_env) {
        String smemString = SoapEncodingUtils.getSMEMinput(request_env);
        if (smemString == null) {
            return false;
        }
        int indexDownload = smemString.indexOf(this.sDownload);
        if (indexDownload != -1) {
            int indexEnd = smemString.indexOf(38, indexDownload + 1);
            return Boolean.parseBoolean(smemString.substring(indexDownload + this.sDownload.length(), indexEnd));
        }
        return false;
    }

    public void createHeaders(String contentType, String userAgent) {
        this.contentType = contentType;
        this.hasHeader = SoapEncodingUtils.hasValidViewerInput(this.envelope);
        if (this.hasHeader) {
            this.createContentDispositionForContentType(contentType, userAgent);
        }
    }

    public void setHeader(HttpServletResponse response) {
        if (this.hasHeader) {
            HttpServletHeader httpServletHeader = new HttpServletHeader(response);
            ContentDispositionCreator.addHeaders(httpServletHeader, this.contentDisposition);
        }
    }

    public boolean isExcelType() {
        return ContentDispositionCreator.isExcel2007(this.contentType) || ContentDispositionCreator.isExcel(this.contentType);
    }

    private void createContentDispositionForContentType(String contentType, String userAgent) {
        ContentDispositionCreator contentDispositionCreator = new ContentDispositionCreator(contentType, this.getReportName(), this.contentTypeFileExtensions, this.forceAttachmentDisposition);
        this.contentDisposition = contentDispositionCreator.createContentDisposition(userAgent);
        log.debug("Content disposition decoded as: ", this.contentDisposition);
    }

    private String getReportName() {
        Element body = this.envelope.getBody();
        log.debug("query response is: ", body.asXML());
        ReportNameExtractor reportNameExtractor = new ReportNameExtractor(body);
        return reportNameExtractor.getReportName();
    }
}

