/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.core;

import com.cognos.pogo.handlers.core.BasicCleanupHandler;
import com.cognos.pogo.http.inprocess.LocalServerConnection;
import com.cognos.pogo.pdk.Cleanable;
import com.cognos.pogo.pdk.Cleaner;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import java.util.List;

public class DoCleanupHandler
extends BasicCleanupHandler
implements Cleaner {
    private static final PogoLogger log = PogoLogger.getLogger();

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (this.canCleanUp(mc)) {
            this.cleanUpAllItems(mc);
        }
    }

    private boolean canCleanUp(MessageContext mc) {
        return LocalServerConnection.isTimeToCleanup(mc, this);
    }

    @Override
    public void cleanUpAllItems(MessageContext mc) {
        List<Cleanable> cleanables = this.getCleanupList(mc);
        if (cleanables != null) {
            this.cleanUpAllItems(mc, cleanables);
        }
    }

    private void cleanUpAllItems(MessageContext mc, List<Cleanable> cleanables) {
        log.debug("Cleaning up ", cleanables.size(), " items");
        for (Cleanable c : cleanables) {
            c.clean(mc);
        }
        cleanables.clear();
    }
}

