/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.debug;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.config.ClusterManager;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.handlers.debug.DescribeHandler;
import com.cognos.pogo.handlers.debug.UtilHandlerBase;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.HandlerPool;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoEngineContext;
import com.cognos.pogo.pdk.PogoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DiagnosticHandler
extends UtilHandlerBase {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(DescribeHandler.class.getName());
    protected Element xmlConfigData;
    PogoEngine pogoEngine;
    HandlerPool hp;

    public DiagnosticHandler() {
        super(cat);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.pogoEngine = engine;
        this.xmlConfigData = this.getConfig();
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
        String action = env.getFormValue("b_action");
        this.hp = this.pogoEngine.getHandlerPool();
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("Diagnostics");
        this.getDispatcherDiagnostics(root);
        this.getMemoryDiagnostics(root);
        this.getCMDiagnostics(root);
        ByteArrayOutputStream baosXML = new ByteArrayOutputStream();
        try {
            PrintWriter pw = new PrintWriter(baosXML);
            pw.println(root.asXML());
            pw.close();
            DiagnosticHandler.prepareResponse(mc, "text/xml", baosXML.toByteArray());
        }
        catch (IOException x) {
            Fault f = new Fault("IOexception preparing response.", x);
            f.setMessageParameters(new Object[]{action});
            mc.setFault(f);
        }
    }

    private void getMemoryDiagnostics(Element root) {
        Runtime rt = Runtime.getRuntime();
        long fm = rt.freeMemory();
        long tm = rt.totalMemory();
        double fmkb = (double)fm / 1000.0;
        double tmkb = (double)tm / 1000.0;
        Element e = root.addElement("Memory");
        e.addAttribute("Amount_of_free_memory_in_the_system", Double.toString(fmkb) + " KB");
        e.addAttribute("Total_memory_in_the_JVM", Double.toString(tmkb) + " KB");
    }

    private void getDispatcherDiagnostics(Element root) {
        Element e = root.addElement("Dispatcher");
        String host = PropertyInserter.getProperty("dispatcher.host");
        String port = PropertyInserter.getProperty("dispatcher.port");
        String capacity = PropertyInserter.getProperty("dispatcher.capacity");
        if (capacity == null || capacity.length() == 0) {
            capacity = "1.0";
        }
        e.addAttribute("host", host);
        e.addAttribute("port", port);
        e.addAttribute("capacity", capacity);
        PogoEngineContext context = this.pogoEngine.getContext();
        ClusterManager clusterManager = (ClusterManager)context.getAttribute("com.cognos.p2plb.clusterManager");
        if (clusterManager != null) {
            // empty if block
        }
    }

    private void getCMDiagnostics(Element root) {
        Element e = root.addElement("CM");
        String host = NodeIdGuidMapper.getContentManagerNID().getHost();
        String port = Integer.toString(NodeIdGuidMapper.getContentManagerNID().getPort());
        e.addAttribute("host", host);
        e.addAttribute("port", port);
    }
}

