/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.debug;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class FakeXTSHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(FakeXTSHandler.class.getName());

    public FakeXTSHandler() {
        super(cat);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (mc.hasResponded()) {
            return;
        }
        Fault fo = mc.getFault();
        if (fo == null) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter w = new PrintWriter(baos);
        try {
            w.println("Content-Type: text/html\n\n");
            w.println("<HTML><HEAD><TITLE>Dispatcher Error</TITLE><HEAD><BODY><H1>An error was detected by the dispatcher.</H1><BR>");
            w.println("Please pretend this is a nicely formatted error page.<PRE>");
            if (fo instanceof SOAPEnvelope || fo instanceof Element) {
                XMLWriter xml_writer = new XMLWriter((Writer)w, new OutputFormat("   ", true));
                if (fo instanceof SOAPEnvelope) {
                    xml_writer.write(((SOAPEnvelope)((Object)fo)).getEnvelope());
                } else {
                    xml_writer.write((Element)fo);
                }
                w.println("</PRE></BODY></HTML>\n");
                xml_writer.close();
            } else if (fo instanceof Exception) {
                Exception x = (Exception)((Object)fo);
                w.println("exception: " + x.getMessage());
                x.printStackTrace(w);
                w.println("</PRE></BODY></HTML>\n");
                w.close();
            } else {
                w.print(fo.toString());
                w.println("</PRE></BODY></HTML>\n");
                w.close();
            }
        }
        catch (IOException x) {
            cat.error("error writing fake XTS response", (Throwable)x);
        }
        ArrayList<ByteArrayInputStream> al = new ArrayList<ByteArrayInputStream>();
        al.add(new ByteArrayInputStream(baos.toByteArray()));
        mc.setProperty("response.attachments", al.iterator());
        mc.setProperty("response.boundary", "hoohaw--wahoow");
        mc.setProperty("response.status_code", "200");
        mc.setProperty("response.status_msg", "OK");
        mc.setProperty("response.headers", new InternetHeaders());
        BIBusEnvelope resp_env = new BIBusEnvelope();
        mc.setProperty("response.envelope", resp_env);
    }
}

