/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.debug;

import com.cognos.p2plb.config.ClusterManager;
import com.cognos.p2plb.model.ClusterNodeView;
import com.cognos.p2plb.model.ClusterView;
import com.cognos.p2plb.strategy.wt_round_robin.Candidate;
import com.cognos.p2plb.strategy.wt_round_robin.CandidateList;
import com.cognos.pogo.handlers.debug.UtilHandlerBase;
import com.cognos.pogo.handlers.errorpage.ContextFactory;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.Cookie;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class PinRequestUIHandler
extends UtilHandlerBase {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(PinRequestUIHandler.class.getName());
    private ClusterManager clusterManager;
    private PogoEngine pogoEngine;
    private String myServerGroup = "";

    public PinRequestUIHandler() {
        super(cat);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.pogoEngine = engine;
        ContextFactory.init();
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
        String pin_action = env.getFormValue("pin_action");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            if (pin_action == null) {
                this.generateForm(mc, pw);
            } else {
                this.processForm(mc, pw);
            }
            pw.close();
            PinRequestUIHandler.prepareResponse(mc, "text/html", baos.toByteArray());
        }
        catch (Exception x) {
            Fault f = new Fault("Exception processing pin request.", x);
            mc.setFault(f);
        }
    }

    private void generateForm(MessageContext mc, PrintWriter pw) throws Exception {
        BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
        String ps = "";
        String rs = "";
        String brs = "";
        String sds = "";
        String scookie = env.getCookieValue("disp_pin");
        if (scookie != null) {
            cat.debug("received disp_pin cookie with value: " + scookie);
            scookie = URLDecoder.decode(scookie, "UTF-8");
            cat.debug("disp_pin cookie decoded value: " + scookie);
            StringTokenizer st = new StringTokenizer(scookie, ";");
            while (st.hasMoreTokens()) {
                String cv = st.nextToken();
                StringTokenizer stc = new StringTokenizer(cv, "=");
                String name = stc.nextToken();
                if ("ps".equals(name)) {
                    ps = stc.nextToken();
                    continue;
                }
                if ("rs".equals(name)) {
                    rs = stc.nextToken();
                    continue;
                }
                if ("brs".equals(name)) {
                    brs = stc.nextToken();
                    continue;
                }
                if (!"sds".equals(name)) continue;
                sds = stc.nextToken();
            }
        }
        VelocityContext context = new VelocityContext();
        String scriptName = env.getEnvironmentValue("SCRIPT_NAME");
        context.put("scriptName", (Object)scriptName);
        context.put("rs", (Object)rs);
        context.put("brs", (Object)brs);
        context.put("ps", (Object)ps);
        context.put("sds", (Object)sds);
        context.put("psDispatchers", this.getDispatcherList("presentationService"));
        context.put("rsDispatchers", this.getDispatcherList("reportService"));
        context.put("brsDispatchers", this.getDispatcherList("batchReportService"));
        context.put("sdsDispatchers", this.getDispatcherList("jobAndScheduleMonitoringService"));
        Velocity.mergeTemplate((String)"com/cognos/pogo/handlers/debug/pinForm.html", (Context)context, (Writer)pw);
        pw.flush();
    }

    private boolean processForm(MessageContext mc, PrintWriter pw) throws Exception {
        BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
        String ps = env.getFormValue("ps");
        String rs = env.getFormValue("rs");
        String brs = env.getFormValue("brs");
        String sds = env.getFormValue("sds");
        StringBuffer sb = new StringBuffer();
        if (ps.length() > 0) {
            sb.append("ps=").append(ps).append(';');
            cat.debug("rxed ps=" + ps);
        }
        if (rs.length() > 0) {
            sb.append("rs=").append(rs).append(';');
            cat.debug("rxed rs=" + rs);
        }
        if (brs.length() > 0) {
            sb.append("brs=").append(brs).append(';');
            cat.debug("rxed brs=" + brs);
        }
        if (sds.length() > 0) {
            sb.append("sds=").append(sds).append(';');
            cat.debug("rxed sds=" + sds);
        }
        if (sb.length() > 0) {
            mc.addCookie(new Cookie("disp_pin", URLEncoder.encode(sb.toString(), "UTF-8")));
            VelocityContext context = new VelocityContext();
            context.put("cookieValue", (Object)sb.toString());
            Velocity.mergeTemplate((String)"com/cognos/pogo/handlers/debug/pinResult.html", (Context)context, (Writer)pw);
            pw.flush();
            return true;
        }
        this.clearCookie(mc, pw);
        return false;
    }

    private void clearCookie(MessageContext mc, PrintWriter pw) throws Exception {
        VelocityContext context = new VelocityContext();
        Velocity.mergeTemplate((String)"com/cognos/pogo/handlers/debug/pinClear.html", (Context)context, (Writer)pw);
        Cookie cookie = new Cookie("disp_pin", "");
        cookie.setMaxAge(0);
        mc.addCookie(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<String> getDispatcherList(String serviceName) {
        ClusterView cv;
        String string = this.myServerGroup;
        synchronized (string) {
            cv = this.clusterManager.getClusterView(this.myServerGroup);
        }
        CandidateList cList = cv.getCandidateList(serviceName);
        return this.getVector(cList);
    }

    private Vector<String> getVector(CandidateList psList) {
        Vector<String> vec = new Vector<String>();
        vec.add("");
        for (int i = 0; i < psList.size(); ++i) {
            Candidate c = psList.get(i);
            ClusterNodeView cnv = (ClusterNodeView)c.getObject();
            vec.add(cnv.getNodeID().toString());
        }
        return vec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(Configuration configuration) {
        String string = this.myServerGroup;
        synchronized (string) {
            this.myServerGroup = configuration.getLocalServerGroup();
        }
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    @Override
    public void initialize() {
        this.clusterManager = (ClusterManager)this.pogoEngine.getContext().getAttribute("com.cognos.p2plb.clusterManager");
    }
}

