/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.dispatchercache;

import com.cognos.pogo.handlers.dispatchercache.CacheFileAttachmentGenerator;
import com.cognos.pogo.handlers.dispatchercache.SessionCacheInfo;
import com.cognos.pogo.impl.PogoSOAPMessageResponder;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.ByteRangeParser;
import com.cognos.pogo.util.CMByteRange;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.InternetHeaders;

public class CacheByteServeResponseGenerator {
    private CacheFileAttachmentGenerator attachementGenerator = null;

    public CacheByteServeResponseGenerator(CacheFileAttachmentGenerator attachementGenerator) {
        this.attachementGenerator = attachementGenerator;
    }

    public void generateByteServeResponse(MessageContext messageContext, SessionCacheInfo sessionCacheInfo) throws IOException {
        List<InputStream> attachements;
        messageContext.setProperty("response.envelope", messageContext.getProperty("request.envelope"));
        List<CMByteRange> rangeList = this.getByteRanges(messageContext);
        if (this.isFullContent(rangeList)) {
            attachements = this.attachementGenerator.generateFullContentAttachment(sessionCacheInfo);
            this.setResponseHeaderForFullContentAttachment(messageContext);
        } else if (this.isOneRangeAttachement(rangeList)) {
            attachements = this.attachementGenerator.generateOneRangeAttachment(sessionCacheInfo, rangeList.get(0));
            this.setResponseHeaderForOneRangeAttachment(messageContext);
        } else {
            attachements = this.attachementGenerator.generateMultiRangeAttachments(sessionCacheInfo, rangeList);
            this.setResponseHeaderForMultiRangeAttachment(messageContext, rangeList);
            messageContext.setProperty("pogo.responder", new PogoSOAPMessageResponder());
        }
        messageContext.setProperty("response.attachments", attachements.iterator());
    }

    List<CMByteRange> getByteRanges(MessageContext messageContext) {
        ArrayList<CMByteRange> rangeLists = null;
        InternetHeaders headers = (InternetHeaders)messageContext.getProperty("request.headers");
        if (headers != null) {
            String ranges = headers.getHeader("Range", ",");
            ByteRangeParser aParser = new ByteRangeParser();
            rangeLists = aParser.parseRangeHeader(ranges);
        }
        return rangeLists;
    }

    boolean isFullContent(List<CMByteRange> rangeList) {
        return rangeList == null || rangeList.isEmpty();
    }

    boolean isOneRangeAttachement(List<CMByteRange> rangeList) {
        return rangeList != null && rangeList.size() == 1;
    }

    private void setResponseHeaderForFullContentAttachment(MessageContext messageContext) {
        messageContext.setProperty("response.status_code", Integer.toString(200));
        InternetHeaders headers = (InternetHeaders)messageContext.getProperty("request.headers");
        messageContext.setProperty("response.headers", headers);
    }

    private void setResponseHeaderForOneRangeAttachment(MessageContext messageContext) {
        messageContext.setProperty("response.status_code", Integer.toString(206));
        InternetHeaders headers = (InternetHeaders)messageContext.getProperty("request.headers");
        messageContext.setProperty("response.headers", headers);
    }

    private void setResponseHeaderForMultiRangeAttachment(MessageContext messageContext, List<CMByteRange> rangeList) {
        messageContext.setProperty("response.status_code", Integer.toString(206));
        messageContext.setProperty("byteRanges", Integer.toString(rangeList.size()));
    }
}

