/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.dispatchercache;

import com.cognos.pogo.handlers.dispatchercache.CacheFileAttachmentGenerator;
import com.cognos.pogo.handlers.dispatchercache.CacheInputStreamFactory;
import com.cognos.pogo.handlers.dispatchercache.SessionCacheInfo;
import com.cognos.pogo.handlers.dispatchercache.StringHeaderBuilder;
import com.cognos.pogo.handlers.dispatchercache.io.HeaderInputStream;
import com.cognos.pogo.handlers.dispatchercache.io.RangeInputStream;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.CMByteRange;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class CacheFileAttachmentGeneratorImpl
implements CacheFileAttachmentGenerator {
    PogoLogger log = PogoLogger.getLogger();
    private final CacheInputStreamFactory cacheInputStreamFactory;
    private final boolean encrypted;

    public CacheFileAttachmentGeneratorImpl(boolean encrypted) {
        this(new CacheInputStreamFactory(new CAMUtils()), encrypted);
    }

    public CacheFileAttachmentGeneratorImpl(CacheInputStreamFactory cacheInputStreamFactory, boolean encrypted) {
        this.cacheInputStreamFactory = cacheInputStreamFactory;
        this.encrypted = encrypted;
    }

    @Override
    public List<InputStream> generateFullContentAttachment(SessionCacheInfo sessionCacheInfo) throws IOException {
        this.log.debug("generateFullContentAttachment");
        String headers = this.createAttachmentHeaderForFullContentAttachment(sessionCacheInfo);
        InputStream inputStream = this.getCacheFileInputStreamWithCompression(sessionCacheInfo, false);
        ArrayList<InputStream> attachments = new ArrayList<InputStream>(1);
        attachments.add(this.createAttachment(headers, inputStream));
        return attachments;
    }

    long getInputStreamSize(SessionCacheInfo sessionCacheInfo) throws IOException {
        if (this.encrypted || sessionCacheInfo.isCompressed()) {
            return this.getFileSizeFromInputStream(sessionCacheInfo);
        }
        return sessionCacheInfo.getFileSize();
    }

    private long getFileSizeFromInputStream(SessionCacheInfo sessionCacheInfo) throws IOException {
        InputStream inputStream = this.getCacheFileInputStream(sessionCacheInfo);
        long size = 0L;
        while (inputStream.read() != -1) {
            ++size;
        }
        return size;
    }

    private InputStream getCacheFileInputStream(SessionCacheInfo sessionCacheInfo) throws IOException {
        boolean compressed = sessionCacheInfo.isCompressed();
        return this.getCacheFileInputStreamWithCompression(sessionCacheInfo, compressed);
    }

    private InputStream getCacheFileInputStreamWithCompression(SessionCacheInfo sessionCacheInfo, boolean compressed) throws IOException {
        String filePath = sessionCacheInfo.getFilePath();
        return this.cacheInputStreamFactory.createInputStream(filePath, compressed, this.encrypted);
    }

    @Override
    public List<InputStream> generateMultiRangeAttachments(SessionCacheInfo sessionCacheInfo, List<CMByteRange> rangeList) throws IOException {
        this.log.debug("generateMultiRangeAttachments");
        ArrayList<InputStream> attachments = null;
        if (rangeList == null || rangeList.size() < 2) {
            throw new IllegalArgumentException("Invalid range list: undefined or contains only one range");
        }
        long inputStreamSize = this.getInputStreamSize(sessionCacheInfo);
        attachments = new ArrayList<InputStream>(rangeList.size());
        for (CMByteRange range : rangeList) {
            this.log.debug("range: ", range);
            RangeInputStream rangeInputStream = this.getRangeInputStream(sessionCacheInfo, range);
            String headers = this.createAttachmentHeaderForMultiRangeAttachment(sessionCacheInfo, inputStreamSize, range);
            attachments.add(this.createAttachment(headers, rangeInputStream));
        }
        return attachments;
    }

    @Override
    public List<InputStream> generateOneRangeAttachment(SessionCacheInfo sessionCacheInfo, CMByteRange range) throws IOException {
        this.log.debug("generateOneRangeAttachment");
        this.log.debug("range: ", range);
        ArrayList<InputStream> attachments = new ArrayList<InputStream>(1);
        RangeInputStream rangeInputStream = this.getRangeInputStream(sessionCacheInfo, range);
        String headers = this.createAttachmentHeaderForOneRangeAttachment(sessionCacheInfo, this.getInputStreamSize(sessionCacheInfo), range);
        attachments.add(this.createAttachment(headers, rangeInputStream));
        return attachments;
    }

    private RangeInputStream getRangeInputStream(SessionCacheInfo sessionCacheInfo, CMByteRange range) throws IOException {
        InputStream cacheFileInputStream = this.getCacheFileInputStream(sessionCacheInfo);
        RangeInputStream rangeInputStream = new RangeInputStream(cacheFileInputStream, range.getStartByte(), range.getEndByte());
        return rangeInputStream;
    }

    String createAttachmentHeaderForFullContentAttachment(SessionCacheInfo sessionCacheInfo) {
        StringHeaderBuilder headers = new StringHeaderBuilder();
        headers.setHeaderValues("Content-ID", "<", sessionCacheInfo.getReportName(), ">");
        headers.setHeader("Content-Type", sessionCacheInfo.getContentType());
        sessionCacheInfo.addHeaders(headers);
        headers.setHeader("Accept-Ranges", "bytes");
        if (sessionCacheInfo.isCompressed()) {
            headers.setHeader("Content-Encoding", "gzip");
        }
        headers.addEmptyLine();
        return headers.toString();
    }

    String createAttachmentHeaderForOneRangeAttachment(SessionCacheInfo sessionCacheInfo, long length, CMByteRange range) {
        StringHeaderBuilder headers = new StringHeaderBuilder();
        headers.setHeaderValues("Content-ID", "<", sessionCacheInfo.getReportName(), ">");
        headers.setHeader("Content-Type", sessionCacheInfo.getContentType());
        sessionCacheInfo.addHeaders(headers);
        headers.setHeaderValues("Content-Range", "bytes ", range.toString() + "/" + String.valueOf(length));
        headers.setHeader("Accept-Ranges", "bytes");
        headers.addEmptyLine();
        return headers.toString();
    }

    String createAttachmentHeaderForMultiRangeAttachment(SessionCacheInfo sessionCacheInfo, long length, CMByteRange range) {
        StringHeaderBuilder headers = new StringHeaderBuilder();
        headers.setHeader("Content-Type", sessionCacheInfo.getContentType());
        headers.setHeaderValues("Content-Range", "bytes ", range.toString() + "/" + String.valueOf(length));
        headers.addEmptyLine();
        return headers.toString();
    }

    private InputStream createAttachment(String header, InputStream payload) {
        return new HeaderInputStream(header, payload);
    }
}

