/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.dispatchercache;

import com.cognos.p2pd.httptools.MimeHeaderUtil;
import com.cognos.pogo.handlers.contentmanager.viewer.ContentDispositionCreator;
import com.cognos.pogo.handlers.dispatchercache.CacheByteServeResponseGenerator;
import com.cognos.pogo.handlers.dispatchercache.CacheFileAttachmentGeneratorImpl;
import com.cognos.pogo.handlers.dispatchercache.CacheFileDescriptor;
import com.cognos.pogo.handlers.dispatchercache.CacheHandler;
import com.cognos.pogo.handlers.dispatchercache.SessionCacheInfo;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.transport.MethodDispatcherCacheExtractor;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.ContentTypeFileExtensions;
import com.cognos.pogo.util.PogoLogger;
import org.apache.axis.utils.StringUtils;

public class CacheFileHandler
extends CacheHandler {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private String cacheObjectsFolder;
    private boolean encryptedCacheFiles;
    private CacheByteServeResponseGenerator generator;

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        if (StringUtils.isEmpty((String)this.cacheObjectsFolder)) {
            this.cacheObjectsFolder = configuration.getICCLConfiguration().resolveEffectivePath(configuration.getValue("temp"));
        }
        this.encryptedCacheFiles = Boolean.parseBoolean(configuration.getValue("encryptTemporaryFiles"));
        this.createResponseGenerator(this.encryptedCacheFiles);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        try {
            SessionCacheInfo sessionCacheInfo = this.setupParameters(mc, contentTypeFileExtensions);
            this.generateByteServeResponse(mc, sessionCacheInfo);
        }
        catch (Exception e) {
            cat.error("Failed during cache file read", e);
            this.replyWith404Error(mc, "Failure during cache file read");
            return;
        }
    }

    protected SessionCacheInfo setupParameters(MessageContext mc, ContentTypeFileExtensions fileExtensions) throws Exception {
        SessionCacheInfo sessionCacheInfo = this.createSessionCacheInfo(mc, fileExtensions);
        this.checkDownloadAttachment(mc, sessionCacheInfo);
        this.setUserAgent(mc, sessionCacheInfo);
        return sessionCacheInfo;
    }

    private SessionCacheInfo createSessionCacheInfo(MessageContext mc, ContentTypeFileExtensions fileExtensions) throws Exception {
        String filename = this.getFilenameFromFormFieldHeader(mc);
        cat.debug("(setupParameters) for file: ", filename);
        CacheFileDescriptor cacheFileDescriptor = new CacheFileDescriptor(this.cacheObjectsFolder);
        return new SessionCacheInfo(cacheFileDescriptor, filename, fileExtensions);
    }

    private void setUserAgent(MessageContext mc, SessionCacheInfo sessionCacheInfo) {
        String userAgent = MimeHeaderUtil.getUserAgent(mc);
        sessionCacheInfo.setUserAgent(userAgent);
    }

    private void checkDownloadAttachment(MessageContext mc, SessionCacheInfo sessionCacheInfo) {
        if (this.forceAttachmentDispositionType(mc)) {
            sessionCacheInfo.setContentDispositionType(ContentDispositionCreator.DispositionType.attachment);
        }
    }

    protected String getFilenameFromFormFieldHeader(MessageContext mc) throws Exception {
        CAMUtils cam = this.getCrypto();
        String base64usid = this.validbase64CAMUserSessionID(mc, cam);
        try {
            MethodDispatcherCacheExtractor mdce = MethodDispatcherCacheExtractor.getInstance(mc, cam);
            if (mdce == null) {
                throw new Exception("Unable to create MethodDispatcherCacheExtracter");
            }
            String fileName = mdce.getFileName();
            if (!mdce.validateURLValues(cam, base64usid)) {
                cat.error("Failed to get URL parameters for dispatcher cache file serve");
                throw new Exception("CAM validation failure");
            }
            return fileName;
        }
        catch (Exception e) {
            cat.error("Failed to get URL parameters for dispatcher cache file serve", e);
            throw e;
        }
    }

    void generateByteServeResponse(MessageContext messageContext, SessionCacheInfo sessionCacheInfo) {
        try {
            this.generator.generateByteServeResponse(messageContext, sessionCacheInfo);
        }
        catch (Exception e) {
            cat.error("Failed to generate byte serve response", e);
            this.replyWith404Error(messageContext, "Failed to generate byte serve response");
        }
    }

    private void createResponseGenerator(boolean encrypted) {
        this.generator = new CacheByteServeResponseGenerator(new CacheFileAttachmentGeneratorImpl(encrypted));
    }

    void configureForJUnit(String tempDir, CAMUtils cu, CacheByteServeResponseGenerator generator) {
        this.cacheObjectsFolder = tempDir;
        this.initializeJUnitCrypto(cu);
        this.generator = generator;
    }

    CacheByteServeResponseGenerator getGeneratorForTesting() {
        return this.generator;
    }
}

