/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.engine;

import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.handlers.engine.PropagateStatus;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import javax.management.MBeanServer;

public class PropagateStatusGlobal
extends PropagateStatus {
    private static PogoLogger log = PogoLogger.getLogger();
    private static ArrayList<String> dispatchers;

    public PropagateStatusGlobal() {
        this.createGlobalExecutor();
    }

    private void createGlobalExecutor() {
        log.debug("Create global executor");
        PropagateStatus.DaemonThreadFactory threadFactory = new PropagateStatus.DaemonThreadFactory();
        executor = Executors.newCachedThreadPool(threadFactory);
    }

    @Override
    protected void configureFromDispatcherList(DispatcherList dispatcherList) {
        super.configureFromDispatcherList(dispatcherList);
        dispatchers = this.getDispatchers(dispatcherList);
    }

    @Override
    public String getServiceStatusFor(String status) {
        if ("suspended".equals(status)) {
            return "dormant";
        }
        return status;
    }

    @Override
    public void propagateStatus() {
        this.propagateGlobally();
    }

    private void propagateGlobally() {
        Collection<? extends Callable<Object>> tasks = this.createCallablesForAllDispatchers();
        try {
            executor.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            log.debug("Exception propagating globally ", e);
        }
    }

    private Collection<? extends Callable<Object>> createCallablesForAllDispatchers() {
        MBeanServer proxyMBeanServer = PogoMBeanServer.getInstance().getProxyMBeanServer();
        ArrayList<UpdateDispatcherCallable> callables = new ArrayList<UpdateDispatcherCallable>();
        if (dispatchers != null) {
            for (String dispatcher : dispatchers) {
                UpdateDispatcherCallable callable = new UpdateDispatcherCallable(proxyMBeanServer, dispatcher);
                callables.add(callable);
            }
        }
        return callables;
    }

    private ArrayList<String> getDispatchers(DispatcherList dispatcherList) {
        ArrayList<String> dispatchers = new ArrayList<String>();
        Collection<String> serverGroups = dispatcherList.getServerGroups();
        for (String serverGroup : serverGroups) {
            Collection<DispatcherListElement> allDispatcherListElements = dispatcherList.getDispatcherListElements(serverGroup);
            for (DispatcherListElement dispatcherListElement : allDispatcherListElements) {
                dispatchers.add(dispatcherListElement.toString());
            }
        }
        return dispatchers;
    }

    final class UpdateDispatcherCallable
    implements Callable<Object> {
        private String dispatcher;
        private MBeanServer proxyMBeanServer;

        public UpdateDispatcherCallable(MBeanServer proxyMBeanServer, String dispatcher) {
            this.proxyMBeanServer = proxyMBeanServer;
            this.dispatcher = dispatcher;
        }

        @Override
        public Object call() throws Exception {
            log.debug("Propagate status to dispatcher ", this.dispatcher);
            PropagateStatus.updateDispatcherOnServer(this.proxyMBeanServer, MBeanUtils.addDispatcherName(PropagateStatus.additionalServicesUpdaterObjectName, this.dispatcher));
            return null;
        }
    }
}

