/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.engine;

import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.logging.Slogger;
import com.cognos.pogo.logging.messages.RequestErrorAuditMsg;
import com.cognos.pogo.logging.messages.RequestErrorDetailAuditMsg;
import com.cognos.pogo.logging.messages.RequestTraceAuditMsg;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.Cam;
import com.cognos.pogo.pdk.common.CamException;
import com.cognos.pogo.util.PogoLogger;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ServiceLookupHandler
extends BasicHandler {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private PogoEngine engine;
    static final LoggingRealm loggingRealm = LoggingRealmFactory.getInstance("DISP");
    static final Slogger slogger = loggingRealm.getLogger(ServiceLookupHandler.class.getName());
    private static final String METDATA_SERVICE = "metadataService";
    private static final String DISP_NAMESPACE_URI = "http://developer.cognos.com/schemas/dispatcher/1";
    private static final Namespace DISPATCHER_NAMESPACE = new Namespace("disp", "http://developer.cognos.com/schemas/dispatcher/1");
    private static final QName UPDATE_METADATA = new QName("updateMetadata", DISPATCHER_NAMESPACE);
    private static final QName QUERY_METADATA = new QName("queryMetadata", DISPATCHER_NAMESPACE);

    public ServiceLookupHandler() {
        super(cat.getNativeLogger());
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.engine = engine;
    }

    private String fixMetadataServiceSOAPAction(String originalSOAPAction, BIBusEnvelope request) {
        Element bodyElement = request.getBody();
        Element anElement = bodyElement.element(UPDATE_METADATA);
        if (anElement != null) {
            return METDATA_SERVICE;
        }
        anElement = bodyElement.element(QUERY_METADATA);
        if (anElement != null) {
            return METDATA_SERVICE;
        }
        return originalSOAPAction;
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        String soapaction = mc.getStrProperty("request.soapaction");
        int pos = soapaction.indexOf(35);
        if (pos != -1) {
            soapaction = soapaction.substring(pos + 1);
        }
        if (DISP_NAMESPACE_URI.equals(soapaction)) {
            BIBusEnvelope soapEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
            soapaction = this.fixMetadataServiceSOAPAction(soapaction, soapEnvelope);
            mc.setProperty("request.soapaction", soapaction);
        }
        cat.info("looking up service for: ", soapaction);
        Handler h = this.engine.lookupService(soapaction);
        if (h == null && soapaction.contains("rxBalancedRequest")) {
            BIBusEnvelope soapEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
            String originalSoapAction = soapEnvelope.getDispatcherTransportValue("originalSOAPAction");
            String localOriginalAction = "local." + originalSoapAction;
            h = this.engine.lookupService(localOriginalAction);
            mc.setProperty("request.soapaction", localOriginalAction);
        }
        if (h == null) {
            cat.error("SOAPAction ", soapaction, " does not map to any known service.");
            Fault f = new Fault("UNKNOWN_SERVICE");
            f.setMessageParameters(new Object[]{soapaction});
            mc.setFault(f);
        } else {
            if (slogger.isEnabledFor(RequestTraceAuditMsg.levelOf())) {
                RequestTraceAuditMsg msg = new RequestTraceAuditMsg(soapaction);
                slogger.log(msg);
            }
            this.engine.invokeHandler(h, mc);
        }
        if (mc.isFaulted()) {
            Fault fault;
            BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
            if (slogger.isEnabledFor(RequestErrorDetailAuditMsg.levelOf())) {
                fault = mc.getFault();
                if (this.isRecoverableCAMFault(fault, requestEnvelope)) {
                    cat.debug("skip logging recoverable CAM fault.");
                } else {
                    slogger.log(new RequestErrorDetailAuditMsg(soapaction, fault, requestEnvelope));
                }
            } else if (slogger.isEnabledFor(RequestErrorAuditMsg.levelOf())) {
                fault = mc.getFault();
                if (this.isRecoverableCAMFault(fault, requestEnvelope)) {
                    cat.debug("skip logging recoverable CAM fault.");
                } else {
                    slogger.log(new RequestErrorAuditMsg(soapaction, fault, requestEnvelope));
                }
            }
        }
        cat.info("finished handling request for service: ", soapaction);
    }

    boolean isRecoverableCAMFault(Fault fault, BIBusEnvelope requestEnvelope) {
        if (!fault.isCreatedFromSOAPEnvelope()) {
            return false;
        }
        SOAPEnvelope faultMsgEnvelope = fault.generateEnvelope(requestEnvelope);
        if (!(faultMsgEnvelope instanceof BIBusEnvelope)) {
            cat.warn("unexpected: fault envelope is not a BIBusEnvelope.");
            return false;
        }
        BIBusEnvelope soapEnvelope = (BIBusEnvelope)faultMsgEnvelope;
        Cam eCAM = this.getCamElement(soapEnvelope);
        if (eCAM == null) {
            return false;
        }
        CamException eException = eCAM.getException();
        if (eException == null) {
            return false;
        }
        String errorCodeString = eException.getErrorCodeString();
        if (errorCodeString == null) {
            cat.warn("unexpected CAM exception without errorCodeString");
            return false;
        }
        return errorCodeString.equalsIgnoreCase("camAuthSystemRecoverable") || errorCodeString.equalsIgnoreCase("camAuthUserRecoverable");
    }

    private Cam getCamElement(BIBusEnvelope soapEnvelope) {
        return soapEnvelope.getBiBusHeader().getCam();
    }
}

