/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.errorpage;

import com.cognos.pogo.handlers.errorpage.ContextFactory;
import com.cognos.pogo.handlers.errorpage.ErrorPageInfo;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class ErrorPageGenerator {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ErrorPageGenerator.class.getName());
    private static final String RESOURCE_PROPERTIES = "DispatcherMessages";

    public static void renderErrorPage(OutputStream os, ErrorPageInfo epInfo) {
        VelocityContext base_context = ContextFactory.getContext(RESOURCE_PROPERTIES, epInfo.getLocale());
        VelocityContext context = new VelocityContext((Context)base_context);
        String s = (String)base_context.get(epInfo.getMsgTag());
        if (s == null) {
            s = epInfo.getMsgTag();
        }
        context.put("error_message", (Object)s);
        context.put("error_component", (Object)"p2pd");
        context.put("error_code", (Object)epInfo.getMsgTag());
        context.put("base_href", (Object)epInfo.getBasehref());
        Boolean t = Boolean.TRUE;
        Iterator<String> itDetails = epInfo.getDetails();
        if (itDetails.hasNext()) {
            StringBuffer sb = new StringBuffer();
            while (itDetails.hasNext()) {
                sb.append(itDetails.next());
                if (!itDetails.hasNext()) continue;
                sb.append(": ");
            }
            context.put("details", (Object)sb.toString());
        } else {
            context.put("ERROR_DETAILS", (Object)t);
        }
        context.put("SHOW_ERROR_LOCATION", (Object)t);
        context.put("MAIL2ADMIN", (Object)t);
        String contactAdmin = epInfo.getContactAdmin();
        if (epInfo.getContactAdmin() != null) {
            context.put("ERRPAGE_CONTACTADMIN", (Object)contactAdmin);
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter(os, "UTF-8");
            Velocity.mergeTemplate((String)"com/cognos/pogo/handlers/errorpage/errorpage.html", (Context)context, (Writer)writer);
            writer.flush();
        }
        catch (Exception e) {
            cat.error("error occured when generating error page.", (Throwable)e);
        }
        context = null;
    }

    public void generateErrorPage(OutputStream os, ErrorPageInfo epInfo) {
        ErrorPageGenerator.renderErrorPage(os, epInfo);
    }
}

