/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.errorpage;

import com.cognos.pogo.handlers.debug.UtilHandlerBase;
import com.cognos.pogo.handlers.errorpage.ErrorPageGenerator;
import com.cognos.pogo.handlers.errorpage.ErrorPageInfo;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;

public class GenLastChanceErrorPage
extends UtilHandlerBase {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static final String MSG_CODE_NO_RESPONSE = "NO_RESPONSE";
    private ErrorPageGenerator errorPageGenerator;

    public GenLastChanceErrorPage() {
        this(new ErrorPageGenerator());
    }

    public GenLastChanceErrorPage(ErrorPageGenerator errorPageGenerator) {
        super(cat.getNativeLogger());
        this.setErrorPageGenerator(errorPageGenerator);
    }

    public void setErrorPageGenerator(ErrorPageGenerator errorPageGenerator) {
        this.errorPageGenerator = errorPageGenerator;
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (this.hasNoResponse(mc)) {
            this.buildSimpleHtmlErrorPage(mc);
        }
    }

    private boolean hasNoResponse(MessageContext mc) {
        return mc.getProperty("response.envelope") == null;
    }

    private void buildSimpleHtmlErrorPage(MessageContext mc) {
        cat.debug("Building last chance error page");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.errorPageGenerator.generateErrorPage(baos, this.createErrorPageInfo(mc));
        this.tryToPrepareResponse(baos, mc);
    }

    private ErrorPageInfo createErrorPageInfo(MessageContext mc) {
        Locale locale = (Locale)mc.getProperty("locale");
        ErrorPageInfo errorPageInfo = new ErrorPageInfo(MSG_CODE_NO_RESPONSE, locale);
        this.addMoreDetailAsNeeded(errorPageInfo, mc, locale);
        return errorPageInfo;
    }

    private void addMoreDetailAsNeeded(ErrorPageInfo epInfo, MessageContext mc, Locale locale) {
        Fault fault = mc.getFault();
        if (this.isMissingNoResponseCode(fault)) {
            this.addFaultDetail(epInfo, fault, locale);
        }
    }

    private boolean isMissingNoResponseCode(Fault fault) {
        return !MSG_CODE_NO_RESPONSE.equals(fault.getMessageCode());
    }

    private void addFaultDetail(ErrorPageInfo epInfo, Fault fault, Locale locale) {
        String faultMsg = fault.prepareMessage(locale);
        epInfo.addDetail(faultMsg);
    }

    private void tryToPrepareResponse(ByteArrayOutputStream baos, MessageContext mc) {
        try {
            GenLastChanceErrorPage.prepareResponse(mc, "text/html; charset=utf-8", baos.toByteArray());
        }
        catch (IOException e) {
            cat.error("Error while generating last chance error page.", e);
        }
    }
}

