/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.fault;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPException;
import com.cognos.pogo.util.Check;
import java.io.StringReader;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class FaultRequestHandler
extends BasicHandler {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(FaultRequestHandler.class.getName());

    public FaultRequestHandler() {
        super(cat);
    }

    @Override
    public void invokeImpl(MessageContext messageContext) throws PogoException {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
        String faultEnvelopeStr = requestEnvelope.getFormValue("soapFault");
        Check.validString(faultEnvelopeStr);
        try {
            BIBusEnvelope faultEnvelope = new BIBusEnvelope(new StringReader(faultEnvelopeStr));
            messageContext.setFault(new Fault("faultEnvelope", faultEnvelope));
        }
        catch (SOAPException ex) {
            messageContext.setFault(new Fault("MALFORMED_REQUEST", ex));
        }
    }
}

