/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.log;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.ibm.bi.logging.glug.support.web.GlugLoggingContext;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class SetupGlugLoggingContextHandler
extends BasicHandler {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(SetupGlugLoggingContextHandler.class.getName());

    public SetupGlugLoggingContextHandler() {
        super(cat);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        if (envelope == null) {
            cat.error("null request.envelope property in MessageContext received by dispatcher!");
            return;
        }
        String transactionHeader = envelope.getDispatcherTransportValue("X-CA-Transaction");
        if (transactionHeader != null && transactionHeader.length() > 0) {
            cat.debug("found transaction id header in soap request, add to logging context");
            GlugLoggingContext.setupLoggingTransactionIDs((String)transactionHeader);
        } else {
            String transactionCookie = envelope.getCookieValue("CATransaction");
            if (transactionCookie != null && transactionCookie.length() > 0) {
                cat.debug("found transaction id cookie, add value to logging context: " + transactionCookie);
                GlugLoggingContext.setupLoggingTransactionIDs((String)transactionCookie);
            } else {
                cat.debug("No transaction id context found in request.envelope " + envelope.toString());
            }
        }
        String sessionCookie = envelope.getCookieValue("ba-logging-session");
        GlugLoggingContext.setupLoggingControl((String)sessionCookie);
    }
}

