/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.logic;

import com.cognos.p2plb.clerver.balancer.RequestForwarder;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Element;

public class PathinfoMappingHandler
extends BasicHandler {
    static final PogoLogger cat = PogoLogger.getLogger();
    private Map<String, String> lookupMap;

    public PathinfoMappingHandler() {
        super(cat.getNativeLogger());
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        TreeMap<String, String> lookup = new TreeMap<String, String>(new LengthComparator());
        Iterator<Element> mappingIt = this.getMappings();
        while (mappingIt.hasNext()) {
            Element e = mappingIt.next();
            String from = e.element("pathinfo").getTextTrim();
            String to = e.element("soapaction").getTextTrim();
            if (from != null && to != null) {
                cat.debug("adding lookup mapping from \"", from, "\" to \"", to);
                lookup.put(from, to);
                continue;
            }
            cat.error("Incorrect table lookup configuration for handler ", this.getName());
        }
        this.lookupMap = Collections.unmodifiableMap(lookup);
    }

    private Iterator<Element> getMappings() {
        Element mappings = this.getConfig().element("mappings");
        return mappings.elementIterator("mapping");
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (this.isBalanceRequest(mc)) {
            return;
        }
        String pathinfo = (String)mc.getProperty("path_info");
        if (pathinfo == null || pathinfo.length() == 0) {
            return;
        }
        for (String path : this.lookupMap.keySet()) {
            if (!pathinfo.startsWith(path)) continue;
            String soapaction = this.lookupMap.get(path);
            if (soapaction != null && soapaction.length() != 0) {
                mc.setProperty("request.soapaction", soapaction);
                cat.debug("Lookup of pathinfo = ", pathinfo, " yielded soapaction = ", soapaction);
            } else {
                cat.debug("Lookup of pathinfo = ", pathinfo, " yielded empty result soap action unchanged");
            }
            return;
        }
        cat.debug("Lookup of pathinfo = ", pathinfo, " no match. soap action unchanged");
    }

    private boolean isBalanceRequest(MessageContext mc) {
        String soapAction = (String)mc.getProperty("request.soapaction");
        return RequestForwarder.SOAP_ACTION.equals(soapAction);
    }

    public class LengthComparator
    implements Comparator<String> {
        @Override
        public int compare(String s1, String s2) {
            return s2.length() - s1.length();
        }
    }
}

