/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.performance;

import com.cognos.cclcorej.util.CCLResourceCounterSet;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.pogo.config.HandlerFactory;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.Version;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class PerformanceIndicationHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(PerformanceIndicationHandler.class.getName());
    protected BasicHandler profiledHandler;
    private static final String PROFILED_HANDLER = "profiledhandler";
    private static final String LEVEL1 = "level1";
    private static final String LEVEL2 = "level2";
    private static final String LEVEL3 = "level3";
    private static final String LEVEL4 = "level4";
    private static final String LEVEL5 = "level5";
    private int level;
    private boolean doThisLevel = false;
    private static LogTypedLogger plog = LogTypedLogger.getInstance((String)"Perf.dispatcher", LogPerfIndication.class);

    public PerformanceIndicationHandler() {
        super(cat);
    }

    protected PerformanceIndicationHandler(Logger subclass_cat) {
        super(subclass_cat);
    }

    public BasicHandler getProfiledHandler() {
        return this.profiledHandler;
    }

    public void setProfileHandler(BasicHandler handler) {
        this.profiledHandler = handler;
    }

    public void setDoThisLevel(boolean bDoThisLevel) {
        this.doThisLevel = bDoThisLevel;
    }

    @Override
    public void contextualize(Element elem) throws PogoException {
        super.contextualize(elem);
        this.getProfilingAttributes(elem);
        Element profiledElement = (Element)elem.selectSingleNode(PROFILED_HANDLER);
        this.profiledHandler = (BasicHandler)HandlerFactory.create(profiledElement);
    }

    private void getProfilingAttributes(Element config) {
        String levelStr = config.attributeValue("level");
        this.level = this.decodeLevel(levelStr);
    }

    private int decodeLevel(String levelStr) {
        if (levelStr.equalsIgnoreCase(LEVEL1)) {
            return 50000;
        }
        if (levelStr.equalsIgnoreCase(LEVEL2)) {
            return 40000;
        }
        if (levelStr.equalsIgnoreCase(LEVEL3)) {
            return 30000;
        }
        if (levelStr.equalsIgnoreCase(LEVEL4)) {
            return 20000;
        }
        if (levelStr.equalsIgnoreCase(LEVEL5)) {
            return 10000;
        }
        return 10000;
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        PerformanceProfiler profiler = null;
        if (this.doThisLevel) {
            profiler = new PerformanceProfiler(mc);
            profiler.start();
        }
        this.profiledHandler.invoke(mc);
        if (profiler != null) {
            profiler.stop();
        }
    }

    @Override
    public void configure(Configuration configuration) {
        this.checkIfEnabled();
        this.profiledHandler.configure(configuration);
    }

    private void checkIfEnabled() {
        this.doThisLevel = plog.isEnabled(this.level);
    }

    @Override
    public void dispose() {
        this.profiledHandler.dispose();
    }

    @Override
    public void initialize() {
        this.profiledHandler.initialize();
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.checkIfEnabled();
        this.profiledHandler.reconfigure(configuration);
    }

    @Override
    public void resume() {
        this.profiledHandler.resume();
    }

    @Override
    public void start() {
        this.profiledHandler.start();
    }

    @Override
    public void stop() {
        this.profiledHandler.stop();
    }

    @Override
    public void suspend(boolean immediate) {
        this.profiledHandler.suspend(immediate);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.profiledHandler.compose(engine);
    }

    public class PerformanceProfiler {
        private CCLResourceCounterSet ctrset;
        private LogPerfIndication pind;

        PerformanceProfiler(MessageContext mc) {
            this.ctrset = new CCLResourceCounterSet(PerformanceIndicationHandler.this.getName(), null);
            this.pind = new LogPerfIndication("DISP", this.getVersion(), this.ctrset);
            this.pind.setLevel(PerformanceIndicationHandler.this.level);
            BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
            this.insertRequestID(env);
            this.insertSessionID(env);
            this.pind.setClassId(this.getClass().getName());
            this.pind.setMethodId(mc.getStrProperty("request.soapaction"));
        }

        private int getVersion() {
            return Version.getVersion();
        }

        private void start() {
            this.ctrset.enableResourceCounter();
            this.pind.setStatus("ENTER");
            plog.log((Object)this.pind);
        }

        private void stop() {
            this.ctrset.disableResourceCounter();
            this.pind.setStatus("EXIT");
            plog.log((Object)this.pind);
        }

        private void insertSessionID(BIBusEnvelope env) {
            String sessionID = env.getPassportID();
            if (sessionID == null) {
                sessionID = env.getSessionContext();
            }
            this.pind.setSessionID(sessionID != null ? sessionID : "");
        }

        private void insertRequestID(BIBusEnvelope env) {
            String requestID = env.getRequestContext();
            this.pind.setRequestID(requestID != null ? requestID : "");
        }
    }
}

