/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.regulate;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.pogo.handlers.regulate.RedirectPogoResponder;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class RegulateRequestHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(RegulateRequestHandler.class.getName());
    private int blockedThreshold;
    private int requestTimeout;
    private int regulatedThreshold;
    private Handler regulatedHandler;
    private String redirectPage;
    private String attributeName;
    private ActiveRequests activeRequests;
    private SemaphoreInvoker semaphoreInvoker;

    public RegulateRequestHandler() {
        super(cat);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        String regulatedHandlerStr = this.getRequiredAttribute(cat, "regulated_handler");
        this.regulatedHandler = engine.getHandlerPool().find(regulatedHandlerStr);
        if (this.regulatedHandler == null) {
            cat.error("cannot find regulated_handler \"" + regulatedHandlerStr + "\"");
            throw new PogoException("cannot find regulated_handler");
        }
        this.regulatedThreshold = this.getNumericAttribute("regulatedThreshold");
        this.createSemaphoreInvoker(this.regulatedThreshold);
        this.blockedThreshold = this.getNumericAttribute("blockedThreshold");
        this.createActiveRequests();
        String requestTimeoutStr = this.getRequiredAttribute(cat, "requestTimeout");
        this.requestTimeout = Integer.parseInt(requestTimeoutStr);
        this.redirectPage = this.getRequiredAttribute(cat, "redirectPage");
        this.setAttributeName(this.getConfig().attributeValue("attributeName"));
    }

    protected void createActiveRequests() {
        this.activeRequests = new ActiveRequests(this.blockedThreshold);
    }

    protected void setAttributeName(String attributeNameValue) {
        this.attributeName = attributeNameValue;
        if (this.attributeName != null && this.attributeName.length() == 0) {
            this.attributeName = null;
        }
    }

    protected int getBlockedThreshold() {
        return this.blockedThreshold;
    }

    private int getNumericAttribute(String name) throws PogoException {
        String strValue = this.getConfig().attributeValue(name);
        if (strValue == null || strValue.length() == 0) {
            return 0;
        }
        return Integer.parseInt(strValue);
    }

    @Override
    public void configure(Configuration configuration) {
        this.reconfigure(configuration);
    }

    @Override
    public void reconfigure(Configuration configuration) {
        if (this.attributeName == null) {
            return;
        }
        try {
            String settings = this.getSettings(configuration);
            if (settings != null) {
                this.checkAttributes(settings);
            }
        }
        catch (CCLConfigurationException e) {
            cat.error("RegulateRequestHandler: CCLConfigurationException", (Throwable)e);
        }
        catch (DocumentException e) {
            cat.error("RegulateRequestHandler: DocumentException", (Throwable)e);
        }
    }

    private String getSettings(Configuration configuration) throws CCLConfigurationException {
        Element settingsElement = configuration.getICCLConfiguration().getValueElement("advancedSettings", false);
        Element elementValue = settingsElement != null ? settingsElement.element("value") : null;
        return elementValue != null ? elementValue.getText() : null;
    }

    private void checkAttributes(String settings) throws DocumentException {
        Element el = DocumentHelper.parseText((String)settings).getRootElement();
        Iterator elit = el.elementIterator();
        while (elit.hasNext()) {
            Element element = (Element)elit.next();
            String nameAttribute = element.attribute("name").getValue();
            if (!nameAttribute.equalsIgnoreCase(this.attributeName)) continue;
            this.checkAttributes(element);
            break;
        }
    }

    private void checkAttributes(Element element) {
        String attrVal = element.getTextTrim();
        StringTokenizer tokenizer = new StringTokenizer(attrVal, ",");
        if (tokenizer.countTokens() > 1) {
            int i2;
            int i1 = Integer.parseInt(tokenizer.nextToken());
            if (i1 < (i2 = Integer.parseInt(tokenizer.nextToken()))) {
                this.adjustRegulatedThreshold(i1);
                this.adjustBlockedThreshold(i2);
            } else {
                this.adjustRegulatedThreshold(i2);
                this.adjustBlockedThreshold(i1);
            }
        } else {
            int i = Integer.parseInt(tokenizer.nextToken());
            if (this.regulatedThreshold == 0) {
                this.adjustBlockedThreshold(i);
            } else {
                this.adjustRegulatedThreshold(i);
            }
        }
    }

    private void adjustBlockedThreshold(int i) {
        if (this.blockedThreshold != i) {
            this.blockedThreshold = i;
            this.activeRequests.setBlockedThreshold(this.blockedThreshold);
        }
    }

    private void adjustRegulatedThreshold(int i) {
        if (this.regulatedThreshold != i) {
            this.regulatedThreshold = i;
            this.createSemaphoreInvoker(this.regulatedThreshold);
        }
    }

    void createSemaphoreInvoker(int permits) {
        this.semaphoreInvoker = new SemaphoreInvoker(permits);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (this.activeRequests.check()) {
            try {
                this.semaphoreInvoker.invokeHandler(this.regulatedHandler, mc);
            }
            finally {
                this.activeRequests.release();
            }
        } else {
            this.redirectToError(mc);
        }
    }

    private void redirectToError(MessageContext mc) {
        Locale locale = (Locale)mc.getProperty("locale");
        StringBuffer localizedRedirectPage = new StringBuffer(this.redirectPage);
        int locpos = this.redirectPage.indexOf("locale");
        if (locpos != -1) {
            localizedRedirectPage.delete(locpos, locpos + 6);
            localizedRedirectPage.insert(locpos, locale.getLanguage());
        }
        mc.setProperty("redirectPage", localizedRedirectPage.toString());
        mc.setProperty("pogo.responder", new RedirectPogoResponder());
        mc.setFault(new Fault("RegulateRequest"));
    }

    void setRegulatedHandlerForTest(Handler handler) {
        this.regulatedHandler = handler;
    }

    private class SemaphoreInvoker {
        private Semaphore semaphore;

        public SemaphoreInvoker(int permits) {
            this.semaphore = permits > 0 ? new Semaphore(permits, true) : null;
        }

        private void invokeHandler(Handler regulatedHandler, MessageContext mc) throws PogoException {
            block6: {
                try {
                    if (this.tryAcquire()) {
                        try {
                            regulatedHandler.invoke(mc);
                            break block6;
                        }
                        finally {
                            this.release();
                        }
                    }
                    RegulateRequestHandler.this.redirectToError(mc);
                }
                catch (InterruptedException e) {
                    RegulateRequestHandler.this.redirectToError(mc);
                }
            }
        }

        private void release() {
            if (this.semaphore != null) {
                this.semaphore.release();
            }
        }

        private boolean tryAcquire() throws InterruptedException {
            if (this.semaphore == null) {
                return true;
            }
            return this.semaphore.tryAcquire(RegulateRequestHandler.this.requestTimeout, TimeUnit.MILLISECONDS);
        }
    }

    private class ActiveRequests {
        private int blockedThreshold;
        private int activeRequests = 0;

        public ActiveRequests(int blockledThreshold) {
            this.blockedThreshold = blockledThreshold;
        }

        synchronized boolean check() {
            if (this.blockedThreshold == 0 || this.activeRequests < this.blockedThreshold) {
                ++this.activeRequests;
                return true;
            }
            return false;
        }

        synchronized void release() {
            --this.activeRequests;
        }

        public synchronized void setBlockedThreshold(int newTheshold) {
            this.blockedThreshold = newTheshold;
        }
    }
}

