/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.regulate;

import com.cognos.pogo.http.mime.MIMEPartParser;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.ConfigurationParameter;
import com.cognos.pogo.util.PogoLogger;
import org.dom4j.Element;

public class WaitForAttachmentCloseHandler
extends BasicHandler {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String WAIT_FOR_ATTACHMENT_TIMEOUT = "waitForAttachmentTimeout";
    private static final long DEFAULT_TIMEOUT = 60000L;
    private long defaultTimeout = 60000L;
    private ConfigurationParameter timeoutParameter;
    private long timeout;
    private String serviceName;

    public WaitForAttachmentCloseHandler() {
        super(log.getNativeLogger());
    }

    @Override
    public void contextualize(Element config) throws PogoException {
        super.contextualize(config);
        try {
            String timeoutAttribute = this.getAttribute(log, "timeout");
            this.defaultTimeout = Long.valueOf(timeoutAttribute);
        }
        catch (NumberFormatException n) {
            log.debug("Using default timeout ", n);
        }
        catch (PogoException e) {
            log.debug("Using default timeout ", e);
        }
        this.serviceName = this.getOptionalAttribute("service");
        this.serviceName = this.serviceName == null ? "" : this.serviceName + ".";
        this.timeoutParameter = new ConfigurationParameter(this.serviceName, "");
        this.timeoutParameter.setDefaultValue(Long.toString(this.defaultTimeout));
    }

    @Override
    public void configure(Configuration configuration) {
        this.timeoutParameter.updateConfiguration(configuration);
        try {
            String timeoutStr = this.timeoutParameter.getValue(WAIT_FOR_ATTACHMENT_TIMEOUT);
            this.timeout = Long.valueOf(timeoutStr);
        }
        catch (NumberFormatException n) {
            log.debug("Using default timeout ", n);
            this.timeout = this.defaultTimeout;
        }
        log.debug("Timeout set to ", this.timeout, " for serviceName ", this.serviceName);
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        Object attachments = mc.getProperty("request.attachments");
        if (attachments != null && attachments instanceof MIMEPartParser) {
            MIMEPartParser mimePartParser = (MIMEPartParser)attachments;
            try {
                mimePartParser.await(this.timeout);
            }
            catch (InterruptedException e) {
                log.debug("Finished waiting for attachments to close ", e);
            }
        }
    }

    long getTimeout() {
        return this.timeout;
    }
}

