/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.tracking;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import java.io.IOException;
import java.io.StringWriter;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ValidateRequestConversationContextHandler
extends BasicHandler {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(ValidateRequestConversationContextHandler.class.getName());
    private boolean validateProcessID;
    private boolean validateAffinityStrength;
    private boolean faultOnValidationError;

    public ValidateRequestConversationContextHandler() {
        super(logger);
    }

    public boolean getValidateProcessID() {
        return this.validateProcessID;
    }

    public boolean getValidateAffinityStrength() {
        return this.validateAffinityStrength;
    }

    public boolean getFaultOnValidationError() {
        return this.faultOnValidationError;
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        String s = this.getRequiredAttribute(logger, "validateProcessID");
        this.validateProcessID = Boolean.valueOf(s);
        s = this.getRequiredAttribute(logger, "validateAffinityStrength");
        this.validateAffinityStrength = Boolean.valueOf(s);
        s = this.getRequiredAttribute(logger, "faultOnValidationError");
        this.faultOnValidationError = Boolean.valueOf(s);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        int affinityStrength;
        String nodeID;
        Boolean prepared = (Boolean)mc.getProperty("PrepareConversationContextHandler.prepared");
        if (prepared != null && prepared.booleanValue()) {
            logger.debug("Conversation context was prepared by PrepareConversationContextHandler, so don't check it.");
            return;
        }
        boolean logEnvelope = false;
        BIBusEnvelope reqEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
        String id = reqEnv.getConversationContextID();
        if (id == null || id.length() == 0) {
            logger.error("request does not contain conversation id.");
            logEnvelope = true;
            if (this.faultOnValidationError) {
                this.logRequestEnvelope(mc);
                mc.setFault(new Fault("MISSING_REQUEST_CONVERSATION_ID"));
                return;
            }
        }
        if ((nodeID = reqEnv.getConversationContextNodeID()) == null || nodeID.length() == 0) {
            logger.error("request does not contain conversation node id.");
            logEnvelope = true;
            if (this.faultOnValidationError) {
                this.logRequestEnvelope(mc);
                mc.setFault(new Fault("MISSING_REQUEST_CONVERSATION_NODEID"));
                return;
            }
        }
        if (this.validateProcessID) {
            int processID = reqEnv.getConversationContextProcessID();
            if (processID == -2) {
                logger.debug("conversation process id is -2, reportserver was started manually.");
            } else if (processID == -1) {
                logger.debug("conversation process id is -1, Request comes from some other service.");
            } else if (processID < 0) {
                logger.error("request does not contain valid conversation process id: " + processID);
                logEnvelope = true;
                if (this.faultOnValidationError) {
                    this.logRequestEnvelope(mc);
                    mc.setFault(new Fault("INVALID_REQUEST_CONVERSATION_PROCESSID"));
                    return;
                }
            }
        }
        if (this.validateAffinityStrength && (affinityStrength = reqEnv.getConversationContextAffinityStrength()) < 0) {
            logger.error("request does not contain valid conversation affinity strength.");
            logEnvelope = true;
            if (this.faultOnValidationError) {
                mc.setFault(new Fault("INVALID_REQUEST_CONVERSATION_AFFINITYSTRENGTH"));
            }
        }
        if (logEnvelope) {
            this.logRequestEnvelope(mc);
        }
    }

    void logRequestEnvelope(MessageContext mc) {
        if (logger.isErrorEnabled()) {
            BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
            StringWriter strWriter = new StringWriter();
            try {
                requestEnvelope.writeAsXML(strWriter);
                logger.error("Request envelope: ");
                logger.error(strWriter.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

