/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.xts;

import com.cognos.pogo.handlers.xts.XtsRequestFactory;
import com.cognos.pogo.handlers.xts.XtsRequestFactorySelector;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.PogoLogger;
import javax.mail.internet.InternetHeaders;

public class PrepareXTSHandleFaultRequest
extends BasicHandler {
    private static final PogoLogger log = PogoLogger.getLogger();
    private String cn_original_request;
    private String cn_xts_request;
    private String xts_path;

    public PrepareXTSHandleFaultRequest() {
        super(log.getNativeLogger());
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.cn_original_request = this.getAttribute(log, "cn_original_request");
        this.cn_xts_request = this.getAttribute(log, "cn_xts_request");
        this.xts_path = this.getAttribute(log, "xts_path");
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (this.hasFault(mc)) {
            this.addXtsProperties(mc);
        }
    }

    private boolean hasFault(MessageContext mc) {
        return !mc.hasResponded() && mc.getFault() != null;
    }

    private void addXtsProperties(MessageContext mc) throws PogoException {
        mc.setProperty(this.cn_xts_request + ".envelope", this.createDom4jXtsRequest(mc));
        mc.setProperty(this.cn_xts_request + ".path", this.xts_path);
        mc.setProperty(this.cn_xts_request + ".headers", new InternetHeaders());
    }

    private SOAPEnvelope createDom4jXtsRequest(MessageContext mc) throws PogoException {
        try {
            return this.createXtsRequest(mc).toDom4j();
        }
        catch (Exception e) {
            throw new PogoException("Can't create XTS Request", e);
        }
    }

    private SOAPEnvelope createXtsRequest(MessageContext mc) {
        SOAPEnvelope originalRequest = (SOAPEnvelope)mc.getProperty(this.cn_original_request + ".envelope");
        XtsRequestFactory xtsRequestFactory = XtsRequestFactorySelector.getFactoryFor(mc);
        return xtsRequestFactory.createXtsRequest(originalRequest, mc.getFault());
    }
}

