/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.xts;

import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.PogoLogger;

public abstract class XtsRequestFactory {
    private static final PogoLogger log = PogoLogger.getLogger();

    protected abstract SOAPEnvelope createXtsEnvelope(SOAPEnvelope var1);

    protected abstract void addBodyFault(SOAPEnvelope var1, SOAPEnvelope var2, SOAPEnvelope var3);

    public SOAPEnvelope createXtsRequest(SOAPEnvelope originalRequest, Fault fault) {
        SOAPEnvelope faultEnvelope = fault.generateEnvelope();
        SOAPEnvelope biBusHeaderSource = this.selectBiBusHeaderSource(fault, faultEnvelope, originalRequest);
        SOAPEnvelope xtsEnvelope = this.createXtsEnvelope(biBusHeaderSource);
        this.addBodyFault(xtsEnvelope, faultEnvelope, originalRequest);
        log.debug("XTS request envelope created: ", xtsEnvelope);
        return xtsEnvelope;
    }

    private SOAPEnvelope selectBiBusHeaderSource(Fault fault, SOAPEnvelope faultEnvelope, SOAPEnvelope originalRequest) {
        return fault.isCreatedFromSOAPEnvelope() ? faultEnvelope : originalRequest;
    }
}

