/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.http.AbstractConnectionPool;
import com.cognos.pogo.http.ConnectionCreator;
import com.cognos.pogo.http.ConnectionOwner;
import com.cognos.pogo.http.RawPostMethodFactory;
import com.cognos.pogo.http.ServerConnection;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ApacheGenericConnectionPool
extends AbstractConnectionPool {
    private static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 60000L;
    private static final long DEFAULT_TIME_BETWEEN_EVICTITION_RUNS_MILLIS = 300000L;
    private static final int UNLIMITED = -1;
    private static final Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(AbstractConnectionPool.class.getName());
    private GenericObjectPool pool;

    public ApacheGenericConnectionPool(GenericObjectPool objectPool) {
        super(null, 0, false, 0, PropertyInserter.getProperty("dispatcher.temp", "../temp/dispatcher"), null);
        this.pool = objectPool;
    }

    public ApacheGenericConnectionPool(String serverHost, int serverPort, boolean serverSsl, int maximumPoolSize, ConnectionCreator creator) {
        this(serverHost, serverPort, serverSsl, maximumPoolSize, PropertyInserter.getProperty("dispatcher.temp", "../temp/dispatcher"), creator);
    }

    public ApacheGenericConnectionPool(String serverHost, int serverPort, boolean serverSsl, int maximumPoolSize, String tempDir, ConnectionCreator creator) {
        super(serverHost, serverPort, serverSsl, maximumPoolSize, tempDir, creator);
        this.pool = new GenericObjectPool((PoolableObjectFactory)new ConnectionFactory(this));
        this.pool.setMinEvictableIdleTimeMillis(60000L);
        this.pool.setTestOnBorrow(true);
        this.pool.setMaxActive(-1);
        this.pool.setMaxIdle(-1);
        this.pool.setTimeBetweenEvictionRunsMillis(300000L);
        this.pool.setTestOnReturn(false);
        this.pool.setTestWhileIdle(false);
    }

    @Override
    public void dispose() {
        try {
            this.setPoolDisposed(true);
            this.pool.clear();
        }
        catch (Exception ex) {
            category.error("pool.clear() threw an exception", (Throwable)ex);
        }
    }

    @Override
    protected ServerConnection getConnection() throws IllegalStateException {
        try {
            ServerConnection aConn = (ServerConnection)this.pool.borrowObject();
            aConn.setConnectionInUse(true);
            aConn.clearCookies();
            return aConn;
        }
        catch (Exception ex) {
            category.error("getConnection() threw an exception", (Throwable)ex);
            return null;
        }
    }

    @Override
    protected Set<ServerConnection> getConnectionsView() {
        return Collections.emptySet();
    }

    @Override
    protected int getCurrentSize() {
        return this.pool.getNumActive();
    }

    @Override
    protected boolean isIdle() {
        return this.pool.getNumActive() == 0;
    }

    @Override
    public void release(ServerConnection aConnection) {
        try {
            if (aConnection.isBadInputStream()) {
                aConnection.refreshHttpClient();
            }
            aConnection.setConnectionInUse(false);
            this.pool.returnObject((Object)aConnection);
        }
        catch (Exception ex) {
            category.error("returnObject() threw an exception", (Throwable)ex);
        }
    }

    GenericObjectPool getInternalObjectPool() {
        return this.pool;
    }

    class ConnectionFactory
    extends BasePoolableObjectFactory {
        ConnectionOwner owner;
        private RawPostMethodFactory defaultHTTPMethodFactory = new RawPostMethodFactory();

        ConnectionFactory(ConnectionOwner o) {
            this.owner = o;
        }

        public Object makeObject() throws Exception {
            return this.newConnection(this.owner, 0);
        }

        public void destroyObject(Object arg0) throws Exception {
            ((ServerConnection)arg0).dispose();
        }

        public void activateObject(Object arg0) throws Exception {
            ((ServerConnection)arg0).recycle();
        }

        public boolean validateObject(Object arg0) {
            boolean bIsValid = true;
            try {
                bIsValid = !((ServerConnection)arg0).shouldCloseConnection();
            }
            catch (IOException e) {
                bIsValid = false;
            }
            return bIsValid;
        }

        public ServerConnection newConnection(ConnectionOwner o, int location) {
            if (ApacheGenericConnectionPool.this.connectionFactory != null) {
                return ApacheGenericConnectionPool.this.connectionFactory.newConnection(o, location);
            }
            return new ServerConnection(this.defaultHTTPMethodFactory, o, location);
        }
    }
}

