/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.http.AbstractConnectionPool;
import com.cognos.pogo.http.ApacheGenericConnectionPool;
import com.cognos.pogo.http.ConnectionCreator;
import com.cognos.pogo.http.ConnectionOwner;
import com.cognos.pogo.http.DefaultConnectionCreator;
import com.cognos.pogo.http.FixedSizeConnectionPool;
import com.cognos.pogo.http.ServerConnection;
import java.util.Set;

public class ConnectionPool
implements ConnectionOwner {
    private AbstractConnectionPool concretePool = null;

    public ConnectionPool(String serverHost, int serverPort, boolean serverSsl, int maximumPoolSize) {
        this(serverHost, serverPort, serverSsl, maximumPoolSize, PropertyInserter.getProperty("dispatcher.temp", "../temp/dispatcher"), new DefaultConnectionCreator());
    }

    public ConnectionPool(String serverHost, int serverPort, boolean serverSsl, int maximumPoolSize, String tempDir) {
        this(serverHost, serverPort, serverSsl, maximumPoolSize, tempDir, new DefaultConnectionCreator());
    }

    public ConnectionPool(String serverHost, int serverPort, boolean serverSsl, int maximumPoolSize, ConnectionCreator creator) {
        this(serverHost, serverPort, serverSsl, maximumPoolSize, PropertyInserter.getProperty("dispatcher.temp", "../temp/dispatcher"), new DefaultConnectionCreator());
    }

    public ConnectionPool(String serverHost, int serverPort, boolean serverSsl, int maximumPoolSize, String tempDir, ConnectionCreator creator) {
        this.concretePool = maximumPoolSize == 0 ? new ApacheGenericConnectionPool(serverHost, serverPort, serverSsl, maximumPoolSize, tempDir, creator) : new FixedSizeConnectionPool(serverHost, serverPort, serverSsl, maximumPoolSize, tempDir, creator);
    }

    public ServerConnection getConnection() throws IllegalStateException {
        return this.concretePool.getConnection();
    }

    @Override
    public void release(ServerConnection aConnection) {
        this.concretePool.release(aConnection);
    }

    @Override
    public void dispose() {
        this.concretePool.dispose();
    }

    public void setNonBlocking(boolean b) {
        this.concretePool.setNonBlocking(b);
    }

    public boolean isDisposed() {
        return this.concretePool.isDisposed();
    }

    public boolean isIdle() {
        return this.concretePool.isIdle();
    }

    public void setDisposeUponFailure(boolean b) {
        this.concretePool.setDisposeUponFailure(b);
    }

    @Override
    public boolean isDisposeUponFailure() {
        return this.concretePool.isDisposeUponFailure();
    }

    public int getCurrentSize() {
        return this.concretePool.getCurrentSize();
    }

    public Set<ServerConnection> getConnectionsView() {
        return this.concretePool.getConnectionsView();
    }

    @Override
    public String getHost() {
        return this.concretePool.getHost();
    }

    @Override
    public int getPort() {
        return this.concretePool.getPort();
    }

    @Override
    public boolean getSsl() {
        return this.concretePool.getSsl();
    }

    @Override
    public CAMFactory getCAMFactory() {
        return this.concretePool.getCAMFactory();
    }

    public void setConnectionFactory(ConnectionCreator creator) {
        this.concretePool.setConnectionFactory(creator);
    }

    public void resizeConnectionPool(int newPoolSize) {
        this.concretePool.resizeConnectionPool(newPoolSize);
    }
}

