/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.http.AbstractConnectionPool;
import com.cognos.pogo.http.ConnectionCreator;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.util.Check;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class FixedSizeConnectionPool
extends AbstractConnectionPool {
    private static final Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(FixedSizeConnectionPool.class.getName());
    private BitSet allocatedConnections;
    private ServerConnection[] clientConnections;

    public FixedSizeConnectionPool(String serverHost, int serverPort, boolean serverSsl, int maximumPoolSize, ConnectionCreator creator) {
        this(serverHost, serverPort, serverSsl, maximumPoolSize, PropertyInserter.getProperty("dispatcher.temp", "../temp/dispatcher"), creator);
    }

    public FixedSizeConnectionPool(String serverHost, int serverPort, boolean serverSsl, int maximumPoolSize, String tempDir, ConnectionCreator creator) {
        super(serverHost, serverPort, serverSsl, maximumPoolSize, tempDir, creator);
        this.allocatedConnections = new BitSet(maximumPoolSize);
        this.clientConnections = new ServerConnection[maximumPoolSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerConnection getConnection() throws IllegalStateException {
        int nextAvailablePosition = -1;
        while (true) {
            if (this.isDisposed()) {
                category.debug("The connection pool has been shutdown");
                throw new IllegalStateException(DispatcherStrings.getInstance().getString("ConnectionPool.poolDisposed"));
            }
            nextAvailablePosition = this.testAndSetNextAvailable();
            if (nextAvailablePosition != -1) break;
            try {
                if (this.isNonBlocking()) {
                    return null;
                }
                FixedSizeConnectionPool fixedSizeConnectionPool = this;
                synchronized (fixedSizeConnectionPool) {
                    this.wait();
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        ServerConnection aConnection = this.assignConnection(nextAvailablePosition);
        Check.assertTrue(!aConnection.isReleased(), "Something really bad happened.  Attempting to assign a connnection that has been released!?");
        if (category.isDebugEnabled()) {
            category.debug("Assigned connection " + nextAvailablePosition + " to " + Thread.currentThread().toString() + ". " + this.checkAvailableConnections() + " free connections available");
        }
        aConnection.setConnectionInUse(true);
        aConnection.clearCookies();
        return aConnection;
    }

    private ServerConnection assignConnection(int position) {
        if (this.clientConnections[position] == null) {
            this.clientConnections[position] = this.connectionFactory.newConnection(this, position);
        } else {
            this.clientConnections[position].recycle();
        }
        return this.clientConnections[position];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int testAndSetNextAvailable() {
        int selectedPosition = -1;
        int maxPool = this.getMaxPoolSize();
        BitSet bitSet = this.allocatedConnections;
        synchronized (bitSet) {
            for (int i = 0; i < maxPool; ++i) {
                if (this.allocatedConnections.get(i)) continue;
                selectedPosition = i;
                this.allocatedConnections.set(selectedPosition);
                break;
            }
        }
        return selectedPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(ServerConnection aConnection) {
        if (aConnection.isBadInputStream()) {
            aConnection.refreshHttpClient();
        }
        int position = aConnection.getPoolLocation();
        Object object = this.allocatedConnections;
        synchronized (object) {
            this.allocatedConnections.clear(position);
        }
        if (category.isDebugEnabled()) {
            category.debug("Released connection " + position + " from " + Thread.currentThread().toString() + ". " + this.checkAvailableConnections() + " free connections available");
        }
        aConnection.setConnectionInUse(false);
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    private int checkAvailableConnections() {
        int available = 0;
        int maxPool = this.getMaxPoolSize();
        for (int i = 0; i < maxPool; ++i) {
            if (this.allocatedConnections.get(i)) continue;
            ++available;
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        BitSet bitSet = this.allocatedConnections;
        synchronized (bitSet) {
            if (this.isDisposed()) {
                return;
            }
            this.setPoolDisposed(true);
            int maxPool = this.getMaxPoolSize();
            for (int i = 0; i < maxPool; ++i) {
                if (this.clientConnections[i] == null) continue;
                this.clientConnections[i].dispose();
                this.clientConnections[i] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIdle() {
        BitSet bitSet = this.allocatedConnections;
        synchronized (bitSet) {
            int maxPool = this.getMaxPoolSize();
            for (int i = 0; i < maxPool; ++i) {
                if (!this.allocatedConnections.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    @Override
    public int getCurrentSize() {
        int useCount = 0;
        int maxPool = this.getMaxPoolSize();
        for (int i = 0; i < maxPool; ++i) {
            if (!this.allocatedConnections.get(i)) continue;
            ++useCount;
        }
        return useCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<ServerConnection> getConnectionsView() {
        HashSet<ServerConnection> returnSet = new HashSet<ServerConnection>(this.clientConnections.length);
        int maxPool = this.getMaxPoolSize();
        BitSet bitSet = this.allocatedConnections;
        synchronized (bitSet) {
            for (int i = 0; i < maxPool; ++i) {
                if (!this.allocatedConnections.get(i)) continue;
                returnSet.add(this.clientConnections[i]);
            }
        }
        return returnSet;
    }
}

