/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http;

import com.cognos.pogo.http.SimpleHttpConnectionManagerWithPrologue;
import com.cognos.pogo.util.PogoLogger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;

public class HttpConnectionManagerFactory {
    private static final PogoLogger log = PogoLogger.getLogger();

    public SimpleHttpConnectionManager createConnectionManager(boolean alwaysCloseConnection) {
        return this.createConnectionManager(alwaysCloseConnection, null);
    }

    public SimpleHttpConnectionManager createConnectionManager(boolean alwaysCloseConnection, byte[] prologue) {
        return prologue == null ? new SimpleHttpConnectionManager(alwaysCloseConnection) : new SimpleHttpConnectionManagerWithPrologue(alwaysCloseConnection, prologue);
    }

    public void shutdownHttpConnectionManager(HttpClient aClient) {
        HttpConnectionManager connectionManager;
        HttpConnectionManager httpConnectionManager = connectionManager = aClient != null ? aClient.getHttpConnectionManager() : null;
        if (connectionManager instanceof SimpleHttpConnectionManager) {
            log.debug("Shutting down HTTP connection manager");
            try {
                ((SimpleHttpConnectionManager)connectionManager).shutdown();
            }
            catch (NullPointerException npe) {
                log.debug("Caught NullPointerException due to a known HttpClient bug (HTTPCLIENT-717). Ignore it");
            }
        }
    }
}

