/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.http.AbstractConnectionPool;
import com.cognos.pogo.http.ConnectionOwner;
import com.cognos.pogo.http.HttpConnectionManagerFactory;
import com.cognos.pogo.http.IRawHttpMethodFactory;
import com.cognos.pogo.http.IRawPostMethodFactory;
import com.cognos.pogo.http.MessageOutputter;
import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.http.httpclient.RawHttpMethod;
import com.cognos.pogo.http.httpclient.RawPostMethod;
import com.cognos.pogo.http.mime.MIMEPartParser;
import com.cognos.pogo.pdk.Cleanable;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.performance.events.HttpRequestEvent;
import com.cognos.pogo.util.Check;
import com.cognos.pogo.util.PogoLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.httpclient.ContentLengthInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;

public class ServerConnection
implements Cleanable {
    private static final PogoLogger log = PogoLogger.getLogger();
    public static final String CONTENT_TYPE = "content-type";
    public static final String MULTIPART_MIME_TYPE = "multipart/related";
    public static final String MULTIPART_BYTERANGES_TYPE = "multipart/byteranges";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    public static final String CONTENT_ENCODING_XGZIP = "x-gzip";
    public static final String CONTENT_ENCODING_DEFLATE = "deflate";
    public static final String CONTENT_ENCODING_COMPRESS = "compress";
    public static final String CONTENT_ENCODING_XCOMPRESS = "x-compress";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String TRANSFER_ENCODING_CHUNCKED = "chunked";
    private static long connectionIdleTimeout;
    public static int defaultHttpClientSocketTimeout;
    private static int defaultSocketTimeoutInMillis;
    private static HttpConnectionManagerFactory httpConnectionManagerFactory;
    protected HttpClient aClient;
    private final int poolLocation;
    private ConnectionOwner owner;
    private boolean released;
    private boolean disposed;
    private RawHttpMethod httpMethod;
    private boolean badInputStream;
    private boolean inUse;
    private boolean isChunked = true;
    private boolean autoRetry = true;
    private int socketTimeout = defaultSocketTimeoutInMillis;
    private int connectionTimeout;
    private long sendStartTime;
    private byte[] prologue = null;
    protected final AtomicLong lastUsed = new AtomicLong();
    protected final AtomicInteger useCount = new AtomicInteger();
    protected String statusText = "";
    private String multiPartBoundary;
    private final IRawPostMethodFactory postMethodFactory;
    private final IRawHttpMethodFactory httpMethodFactory;
    private String signature = null;

    protected ServerConnection(IRawPostMethodFactory methodFactory, ConnectionOwner newOwner, int newPoolLocation) {
        this(methodFactory, newOwner, newPoolLocation, PropertyInserter.getProperty("dispatcher.temp", "../temp/dispatcher"));
    }

    protected ServerConnection(IRawHttpMethodFactory methodFactory, ConnectionOwner newOwner, int newPoolLocation) {
        this(methodFactory, newOwner, newPoolLocation, PropertyInserter.getProperty("dispatcher.temp", "../temp/dispatcher"));
    }

    protected ServerConnection(IRawPostMethodFactory methodFactory, ConnectionOwner newOwner, int newPoolLocation, String tempDir) {
        this.postMethodFactory = methodFactory;
        this.httpMethodFactory = null;
        this.poolLocation = newPoolLocation;
        this.owner = newOwner;
        this.setReleased(false);
        this.updateLastUsed();
        this.inUse = false;
        this.httpMethod = this.createMethod();
    }

    protected ServerConnection(IRawHttpMethodFactory methodFactory, ConnectionOwner newOwner, int newPoolLocation, String tempDir) {
        this.postMethodFactory = null;
        this.httpMethodFactory = methodFactory;
        this.poolLocation = newPoolLocation;
        this.owner = newOwner;
        this.setReleased(false);
        this.updateLastUsed();
        this.inUse = false;
        this.httpMethod = this.createMethod();
    }

    private RawHttpMethod createMethod() {
        if (this.postMethodFactory != null) {
            return this.postMethodFactory.newRawPostMethod();
        }
        return this.httpMethodFactory.newRawHttpMethod();
    }

    protected void setDisposed(boolean b) {
        this.disposed = b;
    }

    protected void setConnectionPool(AbstractConnectionPool cp) {
        this.owner = cp;
    }

    protected void setReleased(boolean b) {
        this.released = b;
    }

    protected boolean getReleased() {
        return this.released;
    }

    protected void setIsBadInputStream(boolean b) {
        this.badInputStream = b;
    }

    public void setQueryString(String queryString) {
        this.httpMethod.setQueryString(queryString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendRequest(String URI2) throws IOException {
        if (this.isReleased()) {
            throw new IllegalStateException("The connection has been released. This connection is no longer usable");
        }
        this.initializeMethod(URI2);
        HttpRequestEvent perfEvent = new HttpRequestEvent(this.httpMethod);
        ServerConnection serverConnection = this;
        synchronized (serverConnection) {
            this.sendStartTime = System.currentTimeMillis();
        }
        try {
            int n = this.executeMethod();
            return n;
        }
        catch (IOException ex) {
            if (this.owner != null && this.owner.isDisposeUponFailure()) {
                this.owner.dispose();
            }
            throw ex;
        }
        finally {
            perfEvent.completed();
        }
    }

    public synchronized boolean shouldCloseConnection() throws IOException {
        long currentTime = System.currentTimeMillis();
        log.debug("Current time: ", currentTime, ", Last used time: ", this.getLastUsed());
        long idleTime = currentTime - this.getLastUsed();
        if (idleTime > connectionIdleTimeout) {
            log.debug("Connection idle for ", idleTime, " ms, should be closed.  Current use count: ", this.useCount);
            return true;
        }
        log.debug("Connection OK. Idle for ", idleTime, " ms, used ", this.useCount, " times.");
        return false;
    }

    public synchronized void setRequestContentType(String type) {
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        this.httpMethod.setRequestHeader(CONTENT_TYPE, type);
    }

    public synchronized void setRequestBodySource(MsgBodyGenerator requestBodySource) {
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        this.httpMethod.setRequestBodyGenerator(requestBodySource);
    }

    public synchronized void setRequestContentLength(int length) {
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        this.httpMethod.setRequestContentLength(length);
        this.isChunked = length == -1;
    }

    public synchronized void setRequestHeader(String name, String value) {
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        this.httpMethod.setRequestHeader(name, value);
    }

    public synchronized void addRequestHeader(String name, String value) {
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        this.httpMethod.addRequestHeader(name, value);
    }

    public synchronized Header[] getResponseHeaders() {
        return this.getResponseHeaders(false);
    }

    public synchronized Header[] getResponseHeaders(boolean raw) {
        Check.assertTrue(!this.isReleased(), "Connection is released!  It SHOULDN'T be!");
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        Header[] headers = this.httpMethod.getResponseHeaders();
        if (raw || this.httpMethod.getResponseHeader(CONTENT_ENCODING) == null) {
            return headers;
        }
        int size = headers.length;
        ArrayList<Header> headerList = new ArrayList<Header>(size);
        for (int i = 0; i < size; ++i) {
            String headerName;
            if (headers[i] == null || CONTENT_ENCODING.equalsIgnoreCase(headerName = headers[i].getName())) continue;
            headerList.add(headers[i]);
        }
        return headerList.toArray(new Header[headerList.size()]);
    }

    public InternetHeaders getResponseHeadersAsInternetHeaders() {
        return this.getResponseHeadersAsInternetHeaders(false);
    }

    public InternetHeaders getResponseHeadersAsInternetHeaders(boolean raw) {
        InternetHeaders responseMimeHeaders = new InternetHeaders();
        Header[] headers = this.getResponseHeaders(raw);
        int size = headers.length;
        for (int i = 0; i < size; ++i) {
            if (headers[i] == null) continue;
            responseMimeHeaders.addHeader(headers[i].getName(), headers[i].getValue());
        }
        return responseMimeHeaders;
    }

    public synchronized String getResponseContentType() {
        Check.assertTrue(!this.isReleased(), "Connection is released!  It SHOULDN'T be!");
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        Header aHeader = this.httpMethod.getResponseHeader(CONTENT_TYPE);
        if (aHeader == null) {
            throw new IllegalStateException("Expected header \"Content-Type\" does not exist in the response.");
        }
        return aHeader.getValue();
    }

    public int getPoolLocation() {
        return this.poolLocation;
    }

    public synchronized HttpClient getHttpClient() {
        if (this.aClient == null) {
            this.setupHTTPClient();
        }
        return this.aClient;
    }

    public void setHttpClient(HttpClient newClient) {
        this.aClient = newClient;
    }

    protected boolean isReleased() {
        return this.released;
    }

    public boolean isMultiPart() {
        Check.assertTrue(!this.isReleased(), "Connection is released!  It SHOULDN'T be!");
        log.debug("Checking content type to see if it's a multipart response");
        String contentTypeValue = this.getResponseContentType();
        log.debug("Content type from the response is: ", contentTypeValue);
        if (!contentTypeValue.regionMatches(true, 0, MULTIPART_MIME_TYPE, 0, MULTIPART_MIME_TYPE.length()) && !contentTypeValue.regionMatches(true, 0, MULTIPART_BYTERANGES_TYPE, 0, MULTIPART_BYTERANGES_TYPE.length())) {
            log.debug("Content-Type is not 'multipart/related' or 'multipart/byteranges', so it's not multipart");
            return false;
        }
        this.multiPartBoundary = MIMEPartParser.getBoundaryFromContentType(contentTypeValue);
        return true;
    }

    public String getMultiPartBoundary() {
        Check.assertTrue(!this.isReleased(), "Connection is released!  It SHOULDN'T be!");
        return this.multiPartBoundary;
    }

    public synchronized InputStream getInputStream() throws IOException {
        InputStream inputStream = this.getUndecoratedInputStream();
        return this.uncompressedInputStream(inputStream);
    }

    public InputStream getContentLimitedInputStream() throws IOException {
        InputStream inputStream = this.getUndecoratedInputStream();
        inputStream = this.getContentLengthInputStream(inputStream);
        return this.uncompressedInputStream(inputStream);
    }

    public InputStream getUndecoratedInputStream() throws IOException {
        Check.assertTrue(!this.isReleased(), "Connection is released!  It SHOULDN'T be!");
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        InputStream inputStream = this.httpMethod.getResponseBodyAsStream();
        return inputStream;
    }

    private synchronized InputStream uncompressedInputStream(InputStream inStream) throws IOException {
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        Header contentEncodingHeader = this.httpMethod.getResponseHeader(CONTENT_ENCODING);
        if (contentEncodingHeader == null) {
            return inStream;
        }
        String contentEncoding = contentEncodingHeader.getValue();
        if (contentEncoding == null || contentEncoding.length() < 1) {
            return inStream;
        }
        if (CONTENT_ENCODING_GZIP.equalsIgnoreCase(contentEncoding) || CONTENT_ENCODING_XGZIP.equalsIgnoreCase(contentEncoding)) {
            return new GZIPInputStream(inStream);
        }
        if (CONTENT_ENCODING_DEFLATE.equalsIgnoreCase(contentEncoding)) {
            return new InflaterInputStream(inStream);
        }
        if (CONTENT_ENCODING_COMPRESS.equalsIgnoreCase(contentEncoding) || CONTENT_ENCODING_XCOMPRESS.equalsIgnoreCase(contentEncoding)) {
            return new ZipInputStream(inStream);
        }
        return inStream;
    }

    private InputStream getContentLengthInputStream(InputStream inStream) {
        Header contentLengthHeader = this.httpMethod.getResponseHeader(CONTENT_LENGTH);
        if (contentLengthHeader == null) {
            return inStream;
        }
        String contentLengthStr = contentLengthHeader.getValue();
        if (contentLengthStr == null || contentLengthStr.length() == 0) {
            log.warn("Content length header received, with no length.  Header is ignored.");
            return inStream;
        }
        try {
            long contentLength = Long.parseLong(contentLengthStr);
            return new ContentLengthInputStream(inStream, contentLength);
        }
        catch (NumberFormatException e) {
            log.warn("Content length header received with invalid length: [", contentLengthStr, "], ignored.");
            return inStream;
        }
    }

    @Deprecated
    public OutputStream getOutputStream() throws IOException {
        Check.assertTrue(!this.isReleased(), "Connection is released!  It SHOULDN'T be!");
        InMemHackMsgBodySrc bodySrc = new InMemHackMsgBodySrc();
        this.setRequestBodySource(bodySrc);
        return bodySrc.getOutputStream();
    }

    public Iterator<InputStream> iterator() throws Exception {
        if (!this.isMultiPart()) {
            return Collections.emptyList().iterator();
        }
        Check.assertTrue(!this.isReleased(), "Connection is released!  It SHOULDN'T be!");
        try {
            return new MIMEPartParser(this.getInputStream(), this.multiPartBoundary);
        }
        catch (Exception ex) {
            log.fatalError("Failed to parse multipart data", ex);
            throw ex;
        }
    }

    public final void release() {
        this.releaseImpl();
    }

    protected void releaseImpl() {
        if (this.isReleased()) {
            log.warn("Ignoring attempt to release a connection that is already released, ", this);
            return;
        }
        log.debug("Connection released after being used for ", System.currentTimeMillis() - this.getLastUsed(), " ms");
        this.setReleased(true);
        this.checkForDisposedConnection();
        this.updateUseCount();
        this.updateLastUsed();
        if (this.isConnectionClosed()) {
            this.forceConnectionOutOfThePool();
        }
    }

    private void checkForDisposedConnection() {
        if (this.isDisposed()) {
            log.warn("Attempting to release a connection that is disposed, ", this);
        } else {
            this.notifyOwner();
        }
    }

    private void notifyOwner() {
        if (this.owner != null) {
            this.owner.release(this);
        }
    }

    private void updateUseCount() {
        this.useCount.incrementAndGet();
    }

    private void resetUseCount() {
        this.useCount.set(0);
    }

    int getUseCount() {
        return this.useCount.get();
    }

    private void updateLastUsed() {
        this.lastUsed.set(System.currentTimeMillis());
    }

    long getLastUsed() {
        return this.lastUsed.get();
    }

    private boolean isConnectionClosed() {
        Header connectionHeader;
        Header header = connectionHeader = this.httpMethod != null ? this.httpMethod.getResponseHeader("connection") : null;
        if (connectionHeader != null && connectionHeader.getValue().equalsIgnoreCase("close")) {
            log.debug("Connection closed by the server after being used ", this.useCount, " times.");
            return true;
        }
        return false;
    }

    private void forceConnectionOutOfThePool() {
        this.lastUsed.set(0L);
    }

    public final synchronized void reinitialize() {
        this.recycle();
    }

    private synchronized void initializeMethod(String URI2) {
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        this.httpMethod.setPath(URI2);
    }

    protected int executeMethod() throws IOException {
        int returnCode = 500;
        try {
            Check.assertTrue(!this.isReleased(), "Connection is released!  It SHOULDN'T be!");
            return this.executeMethodSynchronously();
        }
        catch (IllegalArgumentException e) {
            log.warn("illegal Argument exception ", e);
            throw e;
        }
        catch (Exception e) {
            log.warn("HTTPClient threw an exception", e);
            if (this.isAutoRetry()) {
                log.debug("Request failed... will try again");
                returnCode = this.executeMethodRetrySynchronously();
                if (returnCode != 500) {
                    return returnCode;
                }
            } else {
                log.warn("Auto retry is disabled, will not send connection");
            }
            throw new IOException("Failed to send HTTP request or read HTTP response", e);
        }
    }

    private synchronized int executeMethodSynchronously() throws IOException, HttpException {
        int timeout;
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        if (this.aClient == null) {
            this.setupHTTPClient();
        }
        if ((timeout = this.getSocketTimeout()) >= 0) {
            this.setTimeout(timeout);
        }
        this.addTransferEncodingHeaderIfNeeded();
        int returnCode = this.aClient.executeMethod((HttpMethod)this.httpMethod);
        this.setStatusText(this.httpMethod.getStatusText());
        return returnCode;
    }

    private synchronized int executeMethodRetrySynchronously() {
        int returnCode = 500;
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        this.refreshHttpClient();
        try {
            Check.assertTrue(!this.isReleased(), "Connection is released!  It SHOULDN'T be!");
            if (this.httpMethod.hasBeenUsed()) {
                this.httpMethod = (RawHttpMethod)this.httpMethod.clone();
            }
            returnCode = this.aClient.executeMethod((HttpMethod)this.httpMethod);
            this.setStatusText(this.httpMethod.getStatusText());
        }
        catch (CloneNotSupportedException cnsex) {
            log.warn("request failed, could not retry because resend is not possible.");
        }
        catch (Exception ex) {
            log.warn("Request failed after second attempt", ex);
        }
        return returnCode;
    }

    private void addTransferEncodingHeaderIfNeeded() {
        if (this.isChunked) {
            this.httpMethod.setRequestHeader(TRANSFER_ENCODING, TRANSFER_ENCODING_CHUNCKED);
        }
    }

    public String getStatusText() {
        Check.assertTrue(!this.isReleased(), "Connection is released!  It SHOULDN'T be!");
        return this.statusText;
    }

    public void setStatusText(String text) {
        this.statusText = text;
    }

    public boolean isBadInputStream() {
        return this.badInputStream;
    }

    public void setBadInputStream() {
        this.badInputStream = true;
    }

    protected synchronized void recycle() {
        if (this.isDisposed()) {
            return;
        }
        if (this.isBadInputStream()) {
            this.refreshHttpClient();
        }
        this.setReleased(false);
        this.httpMethod = this.createMethod();
        this.statusText = "recycled";
        this.multiPartBoundary = "";
    }

    protected synchronized void dispose() {
        this.httpMethod.releaseConnection();
        httpConnectionManagerFactory.shutdownHttpConnectionManager(this.aClient);
        this.aClient = null;
        this.disposed = true;
        this.httpMethod = null;
        this.owner = null;
    }

    public synchronized boolean isDisposed() {
        return this.disposed;
    }

    protected ConnectionOwner getConnectionPool() {
        return this.owner;
    }

    protected void refreshHttpClient() {
        this.endSession();
        this.setupHTTPClient();
        this.updateLastUsed();
        this.resetUseCount();
        this.setIsBadInputStream(false);
        int timeout = this.getSocketTimeout();
        if (timeout >= 0) {
            this.setTimeout(timeout);
        }
        if (this.connectionTimeout >= 0) {
            this.setConnectionTimeout();
        }
    }

    public boolean isAutoRetry() {
        return this.autoRetry;
    }

    public void setAutoRetry(boolean autoRetry) {
        this.autoRetry = autoRetry;
    }

    @Override
    public void clean(MessageContext mc) {
        this.release();
    }

    public void addRequestHeaders(InternetHeaders mimeHeaders) {
        if (mimeHeaders == null) {
            return;
        }
        Enumeration eHeaders = mimeHeaders.getAllHeaders();
        while (eHeaders.hasMoreElements()) {
            javax.mail.Header hdr = (javax.mail.Header)eHeaders.nextElement();
            String headerName = hdr.getName();
            if (headerName.equalsIgnoreCase("content-length") || headerName.equalsIgnoreCase("transfer-encoding") || headerName.equalsIgnoreCase("host")) continue;
            this.setRequestHeader(headerName, hdr.getValue());
        }
    }

    protected synchronized void endSession() {
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        this.httpMethod.releaseConnection();
        httpConnectionManagerFactory.shutdownHttpConnectionManager(this.aClient);
    }

    public synchronized void changeTimeout(int newTimeout) {
        if (this.aClient == null) {
            this.setupHTTPClient();
        }
        this.socketTimeout = newTimeout;
        this.setTimeout(newTimeout);
    }

    public synchronized void setConnectionTimeout(int newTimeout) {
        if (this.aClient == null) {
            this.setupHTTPClient();
        }
        this.connectionTimeout = newTimeout;
        this.setConnectionTimeout();
    }

    private void setConnectionTimeout() {
        this.aClient.setConnectionTimeout(this.connectionTimeout);
    }

    private void setTimeout(int timeout) {
        this.aClient.setTimeout(timeout);
    }

    public void setPostMethod(RawPostMethod postMethod) {
        if (postMethod == null) {
            throw new NullPointerException();
        }
        this.httpMethod = postMethod;
    }

    public RawPostMethod getPostMethod() {
        return this.httpMethod instanceof RawPostMethod ? (RawPostMethod)this.httpMethod : null;
    }

    public RawHttpMethod getMethod() {
        return this.httpMethod;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public long getSendStartTime() {
        return this.sendStartTime;
    }

    protected int getServerPort() {
        return this.getConnectionPool().getPort();
    }

    protected void setupHTTPClient() {
        boolean ssl = this.owner.getSsl();
        CAMFactory camFactory = ssl ? this.owner.getCAMFactory() : null;
        this.setupHTTPClient(this.owner.getHost(), this.owner.getPort(), ssl, camFactory);
    }

    protected void setupHTTPClient(String host, int port, boolean ssl, CAMFactory camFactory) {
        try {
            if (this.aClient == null) {
                if (ssl) {
                    if (this.getConnectionPrologue() != null) {
                        throw new CAMCryptoException("Prologue not supported on ssl connections");
                    }
                    CAMFactory camf = camFactory;
                    this.aClient = camf.createHttpClient(host, port, ssl);
                } else {
                    this.aClient = ServerConnection.createNewClient(host, port, this.getConnectionPrologue());
                }
            }
        }
        catch (CAMCryptoException e) {
            this.logConnectionError(host, port, (Exception)((Object)e));
        }
    }

    protected void logConnectionError(String host, int port, Exception e) {
        StringBuffer strBuf = new StringBuffer("Unable to create connection to ");
        strBuf.append(host);
        strBuf.append(":");
        strBuf.append(port);
        log.error(strBuf.toString(), e);
    }

    protected static HttpClient createNewClient(String host, int port) {
        return ServerConnection.createNewClient(host, port, null);
    }

    protected static HttpClient createNewClient(String host, int port, byte[] prologue) {
        SimpleHttpConnectionManager connectionManager = httpConnectionManagerFactory.createConnectionManager(false, prologue);
        HttpClient aClient = new HttpClient((HttpConnectionManager)connectionManager);
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost(host, port);
        aClient.setHostConfiguration(hostConfig);
        return aClient;
    }

    void setConnectionInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public boolean isConnectionInUse() {
        return this.inUse;
    }

    public void clearCookies() {
        if (this.aClient != null) {
            this.aClient.getState().clearCookies();
        }
    }

    public static void setHttpConnectionManagerFactory(HttpConnectionManagerFactory httpConnectionManagerFactory) {
        ServerConnection.httpConnectionManagerFactory = httpConnectionManagerFactory;
    }

    public void setMessageOutputter(MessageOutputter messageOutputter) {
    }

    public boolean isLocal() {
        return false;
    }

    public byte[] getConnectionPrologue() {
        return this.prologue;
    }

    void clearConnectionPrologue() {
        this.prologue = null;
    }

    public void setConnectionPrologue(byte[] prologue) {
        this.prologue = prologue;
    }

    public void setSigature(String s) {
        this.signature = s;
    }

    public String getSigature() {
        return this.signature;
    }

    static {
        defaultSocketTimeoutInMillis = defaultHttpClientSocketTimeout = -1;
        httpConnectionManagerFactory = new HttpConnectionManagerFactory();
        try {
            connectionIdleTimeout = Long.parseLong(PropertyInserter.getProperty("dispatcher.connection_timeout", "10000"));
        }
        catch (NumberFormatException ex) {
            connectionIdleTimeout = 10000L;
        }
        log.debug("Using connection pool idle timeout: ", connectionIdleTimeout);
        String socketTimeoutValue = PropertyInserter.getProperty("dispatcher.socket_timeout", String.valueOf(defaultSocketTimeoutInMillis));
        try {
            defaultSocketTimeoutInMillis = Integer.parseInt(socketTimeoutValue);
        }
        catch (NumberFormatException ex) {
            log.error("Invalid socket timeout property value: [", socketTimeoutValue, "]. Using default timeout: ", defaultSocketTimeoutInMillis);
        }
        log.debug("Using connection pool socket timeout: ", defaultSocketTimeoutInMillis);
    }

    private class InMemHackMsgBodySrc
    implements MsgBodyGenerator {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();

        private InMemHackMsgBodySrc() {
        }

        OutputStream getOutputStream() {
            return this.baos;
        }

        @Override
        public void writeBody(OutputStream os) throws IOException {
            this.baos.writeTo(os);
        }

        @Override
        public boolean rewind() {
            return true;
        }
    }
}

