/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http.inprocess;

import com.cognos.pogo.bibus.SOAPMessageOutputter;
import com.cognos.pogo.http.MessageOutputter;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.http.httpclient.RawPostMethod;
import com.cognos.pogo.http.inprocess.LocalServletRequest;
import com.cognos.pogo.http.inprocess.LocalServletResponse;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Cleanable;
import com.cognos.pogo.pdk.Cleaner;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.performance.events.LocalServletEvent;
import com.cognos.pogo.reportservice.RSComponentFactory;
import com.cognos.pogo.transport.PogoServlet;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.mail.internet.InternetHeaders;
import javax.servlet.ServletException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;

public class LocalServerConnection
extends ServerConnection {
    private static final String NOT_SUPPORTED = "This method is not supported in local server connections";
    private static final PogoLogger log = PogoLogger.getLogger();
    private final PogoServlet pogoServlet;
    private LocalServletRequest localRequest;
    private LocalServletResponse localResponse;
    private String simulatedStatusText;
    private SOAPMessageOutputter messageOutputter;
    private MsgBodyGenerator requestBodySource;
    private MessageContext innerMessageContext;
    private Cleaner innerCleanupHandler;

    public LocalServerConnection() {
        this(PogoServlet.getInstance());
    }

    public LocalServerConnection(PogoServlet pogoServlet) {
        super(new RSComponentFactory(), null, 0);
        this.pogoServlet = pogoServlet;
        this.localRequest = new LocalServletRequest(this);
        this.localResponse = new LocalServletResponse(this);
    }

    @Override
    public void addRequestHeader(String name, String value) {
        this.localRequest.setHeader(name, value);
    }

    @Override
    public void setRequestHeader(String name, String value) {
        this.localRequest.setRequestHeader(name, value);
    }

    @Override
    public void changeTimeout(int newTimeout) {
    }

    @Override
    public void clean(MessageContext mc) {
        log.debug("Cleaning");
        this.release();
    }

    @Override
    protected void releaseImpl() {
        log.debug("Releasing");
        super.releaseImpl();
        if (this.innerCleanupHandler != null) {
            this.innerCleanupHandler.cleanUpAllItems(this.innerMessageContext);
        }
    }

    @Override
    public void clearCookies() {
    }

    @Override
    public int getConnectionTimeout() {
        return 0;
    }

    @Override
    public HttpClient getHttpClient() {
        return null;
    }

    @Override
    public InputStream getContentLimitedInputStream() throws IOException {
        return this.getInputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.localResponse.getClientStream();
    }

    @Override
    public String getMultiPartBoundary() {
        return super.getMultiPartBoundary();
    }

    @Override
    public boolean isMultiPart() {
        return super.isMultiPart();
    }

    @Override
    public String getResponseContentType() {
        return this.localResponse.getContentType();
    }

    @Override
    @Deprecated
    public OutputStream getOutputStream() throws IOException {
        throw new RuntimeException(NOT_SUPPORTED);
    }

    @Override
    public int getPoolLocation() {
        return 0;
    }

    @Override
    public RawPostMethod getPostMethod() {
        throw new RuntimeException(NOT_SUPPORTED);
    }

    @Override
    public Header[] getResponseHeaders() {
        return this.localResponse.getResponseHeaders();
    }

    @Override
    public InternetHeaders getResponseHeadersAsInternetHeaders() {
        return super.getResponseHeadersAsInternetHeaders();
    }

    @Override
    public long getSendStartTime() {
        return 0L;
    }

    @Override
    public int getSocketTimeout() {
        return -1;
    }

    @Override
    public String getStatusText() {
        return this.simulatedStatusText;
    }

    @Override
    public boolean isAutoRetry() {
        return false;
    }

    @Override
    public boolean isBadInputStream() {
        return false;
    }

    @Override
    public boolean isConnectionInUse() {
        return true;
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public Iterator<InputStream> iterator() throws Exception {
        return super.iterator();
    }

    @Override
    public int sendRequest(String uri) throws IOException {
        log.debug("Sending request to the local dispatcher as a local (in-process) servlet request: ", uri);
        this.localRequest.prepareRequest(uri, this.messageOutputter, this.requestBodySource);
        this.callLocalServlet();
        return this.prepareLocalResponse();
    }

    private void callLocalServlet() throws IOException {
        this.localRequest.logRequest();
        LocalServletEvent perfEvent = new LocalServletEvent(this.localRequest);
        try {
            log.info("--> Invoking local servlet");
            this.pogoServlet.doPost(this.localRequest, this.localResponse);
            log.info("<-- Returning control to local servlet client");
        }
        catch (ServletException e) {
            log.warn("Local servlet error", e);
        }
        finally {
            perfEvent.completed(this.localResponse);
        }
    }

    private int prepareLocalResponse() throws IOException {
        this.localResponse.prepareResponse();
        return this.localResponse.getStatus();
    }

    @Override
    public void setAutoRetry(boolean autoRetry) {
    }

    @Override
    public void setBadInputStream() {
    }

    @Override
    public void setConnectionTimeout(int newTimeout) {
    }

    @Override
    public void setPostMethod(RawPostMethod postMethod) {
        throw new RuntimeException(NOT_SUPPORTED);
    }

    @Override
    public void setRequestBodySource(MsgBodyGenerator requestBodySource) {
        this.requestBodySource = requestBodySource;
    }

    @Override
    public void setRequestContentLength(int length) {
        this.localRequest.setRequestContentLength(length);
    }

    @Override
    public void setRequestContentType(String type) {
        this.setRequestHeader("content-type", type);
    }

    @Override
    public void setSocketTimeout(int socketTimeout) {
    }

    @Override
    public void setStatusText(String text) {
        throw new RuntimeException(NOT_SUPPORTED);
    }

    @Override
    public boolean shouldCloseConnection() throws IOException {
        return false;
    }

    public BIBusEnvelope getResponseEnvelope() {
        return this.localResponse.getEnvelope();
    }

    @Override
    protected void refreshHttpClient() {
    }

    @Override
    public void setMessageOutputter(MessageOutputter messageOutputter) {
        this.messageOutputter = (SOAPMessageOutputter)messageOutputter;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public void postponeStreaming(Iterator<InputStream> attachments, byte[] startMimeBoundary, byte[] endMimeBoundary) {
        log.debug("Postponing streaming of attachments. Mime boundary = ", startMimeBoundary);
        this.localResponse.postponeStreaming(attachments, startMimeBoundary, endMimeBoundary);
    }

    public static boolean hasLocalServerConnection(MessageContext mc) {
        return Boolean.valueOf(mc.getStrProperty("hasLocalServerConnection"));
    }

    public static void setHasLocalServerConnection(MessageContext mc, String hasConnection) {
        mc.setProperty("hasLocalServerConnection", hasConnection);
    }

    public static LocalServerConnection getLocalServerConnection(MessageContext mc) {
        return (LocalServerConnection)mc.getProperty("localServerConnection");
    }

    public static void setLocalServerConnection(MessageContext mc, LocalServerConnection localServerConnection) {
        mc.setProperty("localServerConnection", localServerConnection);
        LocalServerConnection.setHasLocalServerConnection(mc, localServerConnection != null ? "true" : "false");
    }

    public static void saveCleanupList(List<Cleanable> cleanupList) {
    }

    public static boolean isTimeToCleanup(MessageContext mc, Cleaner cleanupHandler) {
        Iterator itAttachments;
        if (LocalServerConnection.isInnerRequest(mc) && (itAttachments = (Iterator)mc.getProperty("response.attachments")) != null && itAttachments.hasNext()) {
            LocalServerConnection.getLocalServerConnection(mc).saveCleanupHandler(mc, cleanupHandler);
            return false;
        }
        return true;
    }

    private void saveCleanupHandler(MessageContext innerMessageContext, Cleaner innerCleanupHandler) {
        this.innerMessageContext = innerMessageContext;
        this.innerCleanupHandler = innerCleanupHandler;
    }

    private static boolean isInnerRequest(MessageContext mc) {
        return LocalServerConnection.hasLocalServerConnection(mc);
    }
}

