/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.impl;

import com.cognos.p2pd.util.PropertyInserter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class CookieEncodeInfo {
    static final String COOKIE_ENCODER_PROPERTY = "CustomCookieEncoder";
    static final String ALL_ENCODED_COOKIES_PROPERTY = "CustomCookieEncoder.allCookies";
    static final String LIST_ENCODED_COOKIES_PROPERTY = "CustomCookieEncoder.cookieList";
    static final String COOKIE_ENCODER_PROPERTY_DEFAULT = "false";
    static final String COOKIE_NAME_SEPARATOR = ",";
    private List<String> cookieToEncodeList = null;

    public boolean areAllCookiesCustomEncoded() {
        return Boolean.valueOf(PropertyInserter.getProperty(ALL_ENCODED_COOKIES_PROPERTY, COOKIE_ENCODER_PROPERTY_DEFAULT));
    }

    public boolean isCookieListedAsCustomEncoded(String cookieName) {
        if (this.cookieToEncodeList == null) {
            this.cookieToEncodeList = this.parseCookieList();
        }
        return this.cookieToEncodeList.contains(cookieName);
    }

    List<String> parseCookieList() {
        String cookies = PropertyInserter.getProperty(LIST_ENCODED_COOKIES_PROPERTY, "");
        ArrayList<String> list = new ArrayList<String>();
        if (cookies != null && cookies.trim().length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(cookies.trim(), COOKIE_NAME_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                String name = tokenizer.nextToken().trim();
                if (name.length() <= 0) continue;
                list.add(name);
            }
        }
        return list;
    }
}

