/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.impl;

import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.HandlerPool;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoEngineContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPException;
import com.cognos.pogo.pdk.performance.events.HandlerEvent;
import com.cognos.pogo.pdk.performance.events.RootHandlerEvent;
import com.cognos.pogo.services.DispatcherServices;
import com.cognos.pogo.util.PogoIPFLog;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class PogoEngineImpl
extends PogoEngine {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(PogoEngine.class.getName());
    private HandlerPool handler_pool = new HandlerPool();
    private PogoEngineContext context;
    private Handler root_handler;
    private DispatcherServices dispatcherServices;
    private Set<String> componentList = new HashSet<String>();
    private static Set<String> knownComponentList;

    public PogoEngineImpl(PogoEngineContext context, DispatcherServices dispatcherServices) {
        this.context = context;
        this.dispatcherServices = dispatcherServices;
    }

    public PogoEngineImpl(PogoEngine from) {
        this.handler_pool = from.getHandlerPool();
        this.context = from.getContext();
        this.dispatcherServices = from.getDispatcherServices();
    }

    @Override
    public PogoEngineContext getContext() {
        return this.context;
    }

    public void setRootHandler(Handler handler) {
        this.root_handler = handler;
    }

    public Handler getRootHandler() {
        return this.root_handler;
    }

    @Override
    public void service(MessageContext mc) throws PogoException, SOAPException {
        RootHandlerEvent perfEvent = new RootHandlerEvent(mc);
        try {
            this.root_handler.invoke(mc);
        }
        finally {
            perfEvent.completed();
        }
    }

    @Override
    public Handler lookupService(String path) {
        return this.dispatcherServices.lookupHandler(path);
    }

    @Override
    public Handler lookupHandler(String name) {
        if (this.handler_pool != null) {
            Handler h = this.handler_pool.find(name);
            return h;
        }
        return null;
    }

    @Override
    public void addHandler(Handler handler) {
        this.handler_pool.add(handler.getName(), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeHandler(Handler handler, MessageContext mc) throws PogoException {
        HandlerEvent perfEvent = new HandlerEvent(handler);
        try {
            handler.invoke(mc);
        }
        finally {
            perfEvent.completed();
        }
    }

    @Override
    public HandlerPool getHandlerPool() {
        return this.handler_pool;
    }

    @Override
    public Map<String, Handler> getServiceMap() {
        return this.dispatcherServices.getHandlerMap();
    }

    @Override
    public Object getContextAttribute(String name) {
        return this.getContext().getAttribute(name);
    }

    @Override
    public void addHandlerPool(String serviceName, HandlerPool handlerPool) {
        if (handlerPool != null) {
            Set<String> keySet = handlerPool.keySet();
            for (String handlerName : keySet) {
                Handler h = handlerPool.find(handlerName);
                this.handler_pool.add(serviceName + "." + handlerName, h);
            }
        }
    }

    @Override
    public DispatcherServices getDispatcherServices() {
        return this.dispatcherServices;
    }

    @Override
    public void setDispatcherServices(Object dispatcherServices) {
        this.dispatcherServices = (DispatcherServices)dispatcherServices;
    }

    @Override
    public void logTraceRequest(String msg) {
        PogoIPFLog.getInstance().logTraceRequest(msg);
    }

    @Override
    public void addInstalledComponent(String componentName) {
        this.componentList.add(componentName);
        if (cat.isDebugEnabled()) {
            cat.debug("Adding \"" + componentName + "\" to the list of available components");
        }
    }

    @Override
    public Set<String> getInstalledComponents() {
        return this.componentList;
    }

    public static Set<String> getKnownComponentList() {
        return knownComponentList;
    }

    private void removeHandlersForService(String serviceName) {
        Set<String> handlerKeySet = this.handler_pool.keySet();
        for (String handlerName : new HashSet<String>(handlerKeySet)) {
            if (!handlerName.startsWith(serviceName + ".")) continue;
            this.handler_pool.remove(handlerName);
        }
    }

    @Override
    public void removeService(String serviceName) {
        this.removeHandlersForService(serviceName);
        this.dispatcherServices.removeService(serviceName);
    }

    static {
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.add("adaptiveAnalytics");
        tempSet.add("agentService");
        tempSet.add("analysisStudio");
        tempSet.add("annotationService");
        tempSet.add("batchReportService");
        tempSet.add("contentManagerService");
        tempSet.add("contentManagerCacheService");
        tempSet.add("controllerStudio");
        tempSet.add("dashboardViewer");
        tempSet.add("dataIntegrationService");
        tempSet.add("dataMovementService");
        tempSet.add("deliveryService");
        tempSet.add("dimensionalDataService");
        tempSet.add("eventManagementService");
        tempSet.add("eventStudio");
        tempSet.add("graphicsService");
        tempSet.add("humanTaskService");
        tempSet.add("indexDataService");
        tempSet.add("indexSearchService");
        tempSet.add("indexUpdateService");
        tempSet.add("jobService");
        tempSet.add("logService");
        tempSet.add("metadataService");
        tempSet.add("metricsManagerService");
        tempSet.add("metricStudio");
        tempSet.add("migrationService");
        tempSet.add("mobileService");
        tempSet.add("monitorService");
        tempSet.add("planningAdministrationConsoleService");
        tempSet.add("planningContributor");
        tempSet.add("planningDataService");
        tempSet.add("planningRuntimeService");
        tempSet.add("planningTaskService");
        tempSet.add("presentationService");
        tempSet.add("queryService");
        tempSet.add("queryStudio");
        tempSet.add("reportDataService");
        tempSet.add("reportService");
        tempSet.add("reportStudio");
        tempSet.add("systemService");
        tempSet.add("powerPlayService");
        tempSet.add("powerPlayStudio");
        knownComponentList = Collections.unmodifiableSet(tempSet);
    }
}

