/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.impl;

import com.cognos.pogo.http.inprocess.LocalServerConnection;
import com.cognos.pogo.http.inprocess.LocalServletRequest;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class PogoHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private String pathInfo;
    private String queryString;
    private Locale requestLocale;
    private boolean isPathInfoModifed = false;
    private HttpServletRequest originalRequest;
    private InputStream localRequestStream;

    public PogoHttpServletRequestWrapper(HttpServletRequest request, String theQueryString, String thePathInfo, Locale locale, boolean pathInfoModified) {
        super(request);
        this.originalRequest = request;
        this.pathInfo = thePathInfo;
        this.queryString = theQueryString;
        this.requestLocale = locale;
        this.isPathInfoModifed = pathInfoModified;
    }

    public PogoHttpServletRequestWrapper(HttpServletRequest request, String theQueryString, String thePathInfo, Locale locale) {
        this(request, theQueryString, thePathInfo, locale, false);
    }

    public String getPathInfo() {
        if (this.pathInfo == null && !this.isPathInfoModifed) {
            return super.getPathInfo();
        }
        return this.pathInfo;
    }

    public String getQueryString() {
        if (this.queryString == null) {
            return super.getQueryString();
        }
        return this.queryString;
    }

    public Locale getLocale() {
        if (this.requestLocale == null) {
            return super.getLocale();
        }
        return this.requestLocale;
    }

    public Enumeration<Locale> getLocales() {
        if (this.requestLocale == null) {
            return super.getLocales();
        }
        Vector<Locale> v = new Vector<Locale>(1);
        v.add(this.requestLocale);
        return v.elements();
    }

    public BIBusEnvelope getLocalRequestEnvelope() throws Exception {
        LocalServletRequest localServletRequest = (LocalServletRequest)this.originalRequest;
        return localServletRequest.getEnvelope();
    }

    public LocalServerConnection getLocalServerConnection() throws Exception {
        LocalServletRequest localServletRequest = (LocalServletRequest)this.originalRequest;
        return localServletRequest.getLocalServerConnection();
    }

    public void useLocalRequestStream() {
        LocalServletRequest localServletRequest = (LocalServletRequest)this.originalRequest;
        this.localRequestStream = localServletRequest.getClientStream();
    }

    public void useLocalRequestEnvelope(String envelopeXml) throws Exception {
        this.localRequestStream = new ByteArrayInputStream(envelopeXml.getBytes("UTF-8"));
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.localRequestStream != null ? this.createLocalInputStream() : super.getInputStream();
    }

    private ServletInputStream createLocalInputStream() throws UnsupportedEncodingException {
        return new ServletInputStream(){
            InputStream is;
            {
                this.is = PogoHttpServletRequestWrapper.this.localRequestStream;
            }

            public int read() throws IOException {
                return this.is.read();
            }
        };
    }
}

