/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.impl;

import com.cognos.p2pd.httptools.MimeHeaderUtil;
import com.cognos.pogo.bibus.SOAPMessageOutputter;
import com.cognos.pogo.http.inprocess.LocalServerConnection;
import com.cognos.pogo.impl.PogoResponder;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.mail.internet.InternetHeaders;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class PogoSOAPMessageResponder
extends PogoResponder {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static final PogoLogger perf_cat = PogoLogger.getLoggerFor("perf." + cat.getName());
    private static final InternetHeaders nullInternetHeaders = new InternetHeaders();
    private static final List<InputStream> EMPTY_ATTACHMENTS = Collections.emptyList();

    @Override
    public boolean respondImpl(HttpServletResponse response, MessageContext mc, String cn) throws IOException {
        int status_code = mc.getIntProperty(cn + ".status_code", 500);
        SOAPEnvelope response_env = (SOAPEnvelope)mc.getProperty(cn + ".envelope");
        boolean isMultipleByteRanges = false;
        if (status_code != 304 && response_env == null) {
            cat.error("No response was generated.");
            if (null == mc.getFault()) {
                mc.setFault(new Fault("NO_RESPONSE"));
            }
            return false;
        }
        InternetHeaders response_hdrs = (InternetHeaders)mc.getProperty(cn + ".headers");
        if (response_hdrs == null) {
            response_hdrs = nullInternetHeaders;
        }
        Iterator<InputStream> attachments = this.getAttachments(mc, cn);
        int byteranges = mc.getIntProperty("byteRanges", 0);
        if (byteranges > 0 && attachments != null) {
            if (!this.isLoadBalancedRequest(mc)) {
                response_env = null;
            }
            isMultipleByteRanges = true;
        }
        if (attachments == null) {
            attachments = EMPTY_ATTACHMENTS.iterator();
        }
        String mime_boundary = mc.getStrProperty(cn + ".boundary");
        response.setStatus(status_code);
        response_hdrs.removeHeader("Content-Length");
        response_hdrs.removeHeader("Content-Type");
        response_hdrs.removeHeader("Transfer-Encoding");
        response_hdrs.removeHeader("Server");
        response_hdrs.removeHeader("Set-Cookie");
        MimeHeaderUtil.copyHeaders(response_hdrs, response);
        String[] eTagValues = response_hdrs.getHeader("ETag");
        if (eTagValues != null && eTagValues.length > 0 && eTagValues[0] != null) {
            cat.debug("Using Etag value: ", eTagValues[0]);
            response.setHeader("ETag", this.quoteETagValue(eTagValues[0]));
        }
        if (status_code == 304) {
            response.setContentLength(0);
            response.getOutputStream().flush();
            return true;
        }
        cat.debug("Sending response: ", response_env);
        ServletOutputStream out = response.getOutputStream();
        SOAPMessageOutputter messageOutputter = new SOAPMessageOutputter(isMultipleByteRanges, response_env, attachments, (OutputStream)response.getOutputStream());
        if (mime_boundary != null) {
            messageOutputter.setMimeBoundary(mime_boundary);
            String cid = mc.getStrProperty(cn + ".start");
            if (cid != null) {
                messageOutputter.setMimeStartPartContentID(cid);
            }
        }
        response.setContentType(messageOutputter.getContentType());
        this.handleLocalServerConnection(messageOutputter, mc);
        this.writeSoapMessage((OutputStream)out, messageOutputter, attachments);
        return true;
    }

    private boolean isLoadBalancedRequest(MessageContext mc) {
        Boolean isBalanced = (Boolean)mc.getProperty("balancedRequest");
        return isBalanced != null && isBalanced != false;
    }

    private void handleLocalServerConnection(SOAPMessageOutputter messageOutputter, MessageContext mc) {
        LocalServerConnection localServerConnection = LocalServerConnection.getLocalServerConnection(mc);
        messageOutputter.setLocalServerConnection(localServerConnection);
    }

    private void writeSoapMessage(OutputStream out, SOAPMessageOutputter messageOutputter, Iterator<InputStream> attachments) throws IOException {
        perf_cat.info("Started writing SOAP Message...");
        try {
            messageOutputter.write();
            out.flush();
        }
        catch (IOException ioe) {
            this.closeAllAttachmentStreams(null, attachments);
            throw ioe;
        }
        catch (Exception ex) {
            this.closeAllAttachmentStreams(null, attachments);
            cat.warn("Caught unexpected exception", ex);
            throw new IOException();
        }
        perf_cat.info("Finished writing SOAP Message...");
    }
}

