/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.logging;

import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.logging.Slogger;
import com.cognos.pogo.logging.messages.ServiceEventAuditMsg;

public class SystemEventLogger {
    static final LoggingRealm loggingRealm = LoggingRealmFactory.getInstance("DISP");
    static final Slogger slogger = loggingRealm.getLogger(SystemEventLogger.class.getName());
    private static String operation;

    public static void logSystemStartup() {
        String msg = DispatcherStrings.getInstance().getString("System.Started");
        SystemEventLogger.logAuditMsg(msg, "Start");
    }

    public static void logSystemShutdown() {
        String msg = DispatcherStrings.getInstance().getString("System.Stopped");
        SystemEventLogger.logAuditMsg(msg, "Stop");
    }

    private static void logAuditMsg(String msg, String operation) {
        SystemEventLogger.operation = operation;
        ServiceEventAuditMsg auditMsg = new ServiceEventAuditMsg("Dispatcher", operation);
        auditMsg.setLogData(msg);
        slogger.log(auditMsg);
    }

    public static String getOperation() {
        return operation;
    }
}

