/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring;

import com.cognos.pogo.monitoring.DurationCounter;
import com.cognos.pogo.monitoring.InstantaneousValue;
import com.cognos.pogo.monitoring.RequestInfo;
import com.cognos.pogo.monitoring.RequestReporter;
import com.cognos.pogo.monitoring.jmx.ProcessMetrics;
import com.cognos.pogo.monitoring.jmx.QueueMetrics;

public class QueueableRequestReporter
extends RequestReporter {
    DurationCounter requestQueueTimeCounter = new DurationCounter("requestQueue");
    InstantaneousValue queueDepthCounter = new InstantaneousValue("queueDepth");
    InstantaneousValue processCounter = new InstantaneousValue("processCount");
    private QueueMetrics queueMetrics;
    private ProcessMetrics processMetrics;

    public QueueableRequestReporter(String serviceName, String serviceType) {
        super(serviceName, serviceType);
        this.addCounter(this.requestQueueTimeCounter);
        this.addCounter(this.queueDepthCounter);
        this.addCounter(this.processCounter);
        this.queueMetrics = new QueueMetrics("queue", serviceType);
        this.processMetrics = new ProcessMetrics("process", serviceType);
        this.server.registerMBean(this.queueMetrics, serviceType);
        this.server.registerMBean(this.processMetrics, serviceType);
    }

    public synchronized void reportSuccess(RequestInfo ri) {
        super.reportSuccess(ri.getProcessTime());
        if (ri.wasQueued()) {
            this.requestQueueTimeCounter.update(ri.getQueueTime());
            this.queueDepthCounter.update(ri.getQueueDepth());
            this.setQueueTimeDepth(ri);
        }
    }

    private void setQueueTimeDepth(RequestInfo ri) {
        this.queueMetrics.update(ri.getQueueDepth(), ri.getQueueTime());
    }

    @Override
    public synchronized void reportSuccess(long msProcessTime) {
        super.reportSuccess(msProcessTime);
    }

    public void reportFailure(RequestInfo ri) {
        super.reportFailure(ri.getProcessTime());
        if (ri.wasQueued()) {
            this.requestQueueTimeCounter.update(ri.getQueueTime());
            this.queueDepthCounter.update(ri.getQueueDepth());
            this.setQueueTimeDepth(ri);
        }
    }

    @Override
    public synchronized void reportFailure(long msProcessTime) {
        super.reportFailure(msProcessTime);
    }

    public synchronized void reportQueueDepth(int iDepth) {
        this.queueDepthCounter.update(iDepth);
    }

    public synchronized void reportProcessCount(int processCount) {
        this.processCounter.update(processCount);
        this.processMetrics.setNumberOfProcesses(processCount);
    }

    public void reportConfiguredProcessCount(int processCount) {
        this.processMetrics.setNumberOfConfiguredProcesses(processCount);
    }

    public void incrementNumberOfUnexpectedAbortedProcesses() {
        this.processMetrics.incrementNumberOfUnexpectedAbortedProcesses();
    }

    public void incrementNumberOfHungProcesses() {
        this.processMetrics.incrementNumberOfHungProcesses();
    }
}

