/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring;

import com.cognos.pogo.monitoring.CounterBase;
import com.cognos.pogo.monitoring.RuntimeInfoReporter;
import com.cognos.pogo.monitoring.ServiceStatus;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.RequestMetrics;
import com.cognos.pogo.monitoring.jmx.RequestMetricsNoComposite;
import java.util.ArrayList;

public class ReporterBase
extends RuntimeInfoReporter {
    private ArrayList<CounterBase> counters = new ArrayList();
    protected ServiceStatus statusCounter = new ServiceStatus();
    boolean statusChanged = false;
    protected PogoMBeanServer server;
    protected RequestMetricsNoComposite requestMetrics;

    public ReporterBase(String serviceName, String serviceType) {
        super(serviceName, serviceType);
        this.addCounter(this.statusCounter);
        this.server = PogoMBeanServer.getInstance();
        this.requestMetrics = PogoMBeanServer.isNoJMX() ? new RequestMetricsNoComposite("request", serviceType) : new RequestMetrics("request", serviceType);
    }

    @Override
    public synchronized void getXML(StringBuffer sb) {
        sb.append('<').append(this.getServiceName()).append('>');
        for (CounterBase counter : this.counters) {
            counter.getXML(sb);
        }
        sb.append("</").append(this.getServiceName()).append('>');
    }

    @Override
    public synchronized void reset() {
        for (CounterBase counter : this.counters) {
            counter.reset();
        }
    }

    protected void addCounter(CounterBase counter) {
        this.counters.add(counter);
    }

    public synchronized void setServiceStatus(String status) {
        this.statusCounter.setState(status);
        this.statusChanged = true;
        if (!status.equals("stopping")) {
            this.requestMetrics.setOperationalStatus(ServiceStatus.getMuwsState(status));
        }
    }

    public synchronized String getServiceStatus() {
        return this.statusCounter.getState();
    }

    public void setStatusChanged(boolean b) {
        this.statusChanged = b;
    }

    public boolean isStatusChanged() {
        return this.statusChanged;
    }
}

