/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring;

import com.cognos.pogo.monitoring.DurationCounter;
import com.cognos.pogo.monitoring.ReporterBase;
import com.cognos.pogo.monitoring.SimpleCount;
import com.cognos.pogo.monitoring.jmx.RequestMetricsNoComposite;
import java.util.HashMap;

public class RequestReporter
extends ReporterBase {
    protected DurationCounter requestTimeCounter = new DurationCounter("requestProcess");
    private DurationCounter failureTimeCounter = new DurationCounter("failureProcess");
    private SimpleCount failures = new SimpleCount("failures");
    private static HashMap<String, RequestMetricsNoComposite> requestMetricsMap = new HashMap();

    public RequestReporter(String serviceName, String serviceType) {
        super(serviceName, serviceType);
        this.addCounter(this.requestTimeCounter);
        this.addCounter(this.failures);
        requestMetricsMap.put(serviceType, this.requestMetrics);
        this.server.registerMBean(this.requestMetrics, serviceType);
    }

    public void reportSuccess(long msProcessTime) {
        this.requestTimeCounter.update(msProcessTime);
        this.requestMetrics.setServiceTimeSuccessfulRequests(msProcessTime);
    }

    public void reportFailure(long msProcessTime) {
        this.failures.increment();
        this.failureTimeCounter.update(msProcessTime);
        this.requestMetrics.setServiceTimeFailedRequests(msProcessTime);
    }

    public void incrementInitialRequests(String serviceName) {
        RequestMetricsNoComposite serviceRequestMetrics = requestMetricsMap.get(serviceName);
        if (serviceRequestMetrics != null) {
            serviceRequestMetrics.incrementNumberOfReceivedRequests();
        }
    }
}

