/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring;

import com.cognos.pogo.monitoring.RequestReporter;
import com.cognos.pogo.monitoring.RuntimeInfoPublisher;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import org.apache.commons.lang.StringUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class SimpleRequestReportingHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(SimpleRequestReportingHandler.class.getName());
    private RequestReporter requestReporter = null;
    private String publisherName;
    private String reporterName;
    private String serviceType;
    private String setStatus = "true";
    private PogoEngine engine;
    private boolean notStartable = false;

    public SimpleRequestReportingHandler() {
        super(cat);
    }

    public SimpleRequestReportingHandler(Logger category) {
        super(category);
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public String getReporterName() {
        return this.reporterName;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getSetStatus() {
        return this.setStatus;
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.engine = engine;
        this.publisherName = this.getOptionalAttribute("publisherName");
        this.reporterName = this.getRequiredAttribute(cat, "reporterName");
        this.serviceType = this.getRequiredAttribute(cat, "serviceType");
        String setStatusStr = this.getConfig().attributeValue("setStatus");
        if (setStatusStr != null) {
            if (setStatusStr.equalsIgnoreCase("false")) {
                this.setStatus = "false";
            } else if (setStatusStr.equalsIgnoreCase("started")) {
                this.setStatus = "started";
            }
        }
        this.requestReporter = this.instantiateReporter(this.reporterName, this.serviceType);
    }

    protected RequestReporter instantiateReporter(String reporterName, String serviceType) {
        return new RequestReporter(reporterName, serviceType);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        String initialFlag = mc.getStrProperty("initialReporterFlag");
        if (initialFlag != null && initialFlag.equals("true")) {
            String serviceName = this.engine.getDispatcherServices().getServiceForPath(mc.getStrProperty("request.soapaction"));
            this.requestReporter.incrementInitialRequests(serviceName);
        } else if (mc.isFaulted()) {
            Fault fault = mc.getFault();
            String msgCode = fault.getMessageCode();
            if (msgCode.equals("PROBABLE_AUTHENTICATION_FAULT")) {
                cat.warn("logon is required to access service:" + this.reporterName);
            } else {
                this.requestReporter.reportFailure(System.currentTimeMillis() - mc.getArrivalTime());
            }
        } else {
            this.requestReporter.reportSuccess(System.currentTimeMillis() - mc.getArrivalTime());
        }
    }

    @Override
    public void configure(Configuration configuration) {
        RuntimeInfoPublisher rtiPublisher = this.getRuntimeInfoPublisher();
        if (rtiPublisher != null) {
            rtiPublisher.addReporter(this.requestReporter);
            cat.debug("Reporter \"" + this.reporterName + "\" added to publisher \"" + this.publisherName);
        }
    }

    private RuntimeInfoPublisher getRuntimeInfoPublisher() {
        if (StringUtils.isBlank((String)this.publisherName)) {
            return null;
        }
        return (RuntimeInfoPublisher)this.engine.getContextAttribute(this.publisherName);
    }

    @Override
    public void resume() {
        if (this.notStartable) {
            return;
        }
        if (this.setStatus.equals("true") || this.setStatus.equals("started")) {
            this.requestReporter.setServiceStatus("running");
        }
    }

    @Override
    public void start() {
        if (this.notStartable) {
            return;
        }
        if (this.setStatus.equals("true") || this.setStatus.equals("started")) {
            this.requestReporter.setServiceStatus("running");
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void suspend(boolean immediate) {
        if (this.setStatus.equals("true")) {
            this.requestReporter.setServiceStatus("suspended");
        }
        if (this.setStatus.equals("started")) {
            this.requestReporter.setServiceStatus("running");
        }
    }

    public RequestReporter getRequestReporter() {
        return this.requestReporter;
    }

    @Override
    public void flagNotStartable() {
        this.notStartable = true;
        this.requestReporter.setServiceStatus("suspended");
    }
}

