/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.monitoring.jmx.DispatcherUpdatesNotifier;
import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.ProxyMBeanManager;
import com.cognos.pogo.monitoring.jmx.ProxyServerCreator;
import com.cognos.pogo.monitoring.jmx.ProxyType;
import com.cognos.pogo.monitoring.jmx.ping.PingTask;
import com.cognos.pogo.monitoring.jmx.ping.ProxyResetter;
import com.cognos.pogo.monitoring.jmx.threshold.ConsolidatedThresholdManager;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.dom4j.Element;

public class ActiveProxyServerCreator
extends ProxyServerCreator
implements ProxyResetter {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private ArrayList<String> proxyList = new ArrayList();
    private ProxyMBeanManager proxyMBeanManager;
    private ConsolidatedThresholdManager thresholdManager;
    private Timer timer = new Timer(true);
    private static final int DEFAULT_PING_INTERVAL = 30000;
    private long pingInterval = 30000L;
    private DispatcherUpdatesNotifier remoteDispatcherUpdatesNotifier;
    private PingTask pingTask;

    public ActiveProxyServerCreator(ProxyServerCreator oldProxyServerCreator) {
        this(oldProxyServerCreator, new ConsolidatedThresholdManager());
    }

    public ActiveProxyServerCreator(ProxyServerCreator oldProxyServerCreator, ConsolidatedThresholdManager thresholdManager) {
        super(oldProxyServerCreator);
        this.thresholdManager = thresholdManager;
        this.remoteDispatcherUpdatesNotifier = new DispatcherUpdatesNotifier();
    }

    @Override
    public void reconfigure(Configuration configuration) {
        cat.debug("reconfigure() - reconfigue active proxy server creator.");
        super.reconfigure(configuration);
        DispatcherList dispatcherList = (DispatcherList)configuration.getDispatcherList();
        this.resetProxyMBeans(dispatcherList);
        this.stopTimer();
        this.startTimer();
    }

    @Override
    public void resetProxyMBeans(DispatcherList dispatcherList) {
        try {
            this.proxyMBeanManager.resetDispatcherList(dispatcherList);
        }
        catch (Exception e) {
            cat.error("reconfigure() - Unable to reset dispatcher list: ", e);
        }
        this.notifyDispatchers();
    }

    @Override
    public void start() {
        this.loadAttributes(this.config);
        this.createProxyServer();
        cat.debug("start create proxy mbeans");
        this.createProxyMBeans();
        cat.debug("recreate thresholds");
        this.recreateProxyThresholds();
        cat.debug("proxy finished");
        this.notifyDispatchers();
        this.startTimer();
    }

    private void notifyDispatchers() {
        if (this.proxyMBeanManager != null && this.proxyMBeanManager.haveProxiesChanged()) {
            DispatcherList dispatcherList = (DispatcherList)this.configuration.getDispatcherList();
            this.remoteDispatcherUpdatesNotifier.notifyDispatchers(dispatcherList);
        }
    }

    private void createProxyServer() {
        try {
            PogoMBeanServer.getInstance().createProxyMBeanServer();
        }
        catch (Exception e) {
            cat.error("Unable to create proxy MBean server", e);
        }
    }

    void loadAttributes(Element config) {
        for (Element attrElem : config.selectNodes("proxylist/proxy")) {
            String name = attrElem.getTextTrim();
            if (MBeanUtils.isSystemJmxDomain(name)) {
                this.proxyList.add(name);
                continue;
            }
            this.proxyList.add(MBeanUtils.replaceJmxDomainWithCurrent(name));
        }
    }

    protected void createProxyMBeans() {
        try {
            DispatcherList dispatcherList = (DispatcherList)this.configuration.getDispatcherList();
            this.proxyMBeanManager = new ProxyMBeanManager();
            this.proxyMBeanManager.createProxies(this.proxyList, this.thresholdManager, dispatcherList);
        }
        catch (Exception e) {
            cat.error("Unable to create proxy MBean server", e);
        }
    }

    protected void recreateProxyThresholds() {
        this.thresholdManager.recreateConsolidatedThresholds();
    }

    List<String> getProxyList() {
        return this.proxyList;
    }

    public void removeAllJMXConnections() {
        this.proxyMBeanManager.removeAllConnections();
    }

    @Override
    public void deactivate() {
        try {
            this.stopTimer();
            MBeanServer proxyMBeanServer = PogoMBeanServer.getInstance().getProxyMBeanServer();
            cat.debug("Deactive Proxy server: " + proxyMBeanServer);
            MBeanServerFactory.releaseMBeanServer(proxyMBeanServer);
            this.removeAllJMXConnections();
            PogoMBeanServer.getInstance().stopProxyConnectors();
        }
        catch (Exception e) {
            cat.debug("Deactive proxy failed: ", e);
        }
    }

    @Override
    public ProxyType getType() {
        return ProxyType.ACTIVE;
    }

    @Override
    public Collection<JMXDispatcher> getDispatchers() {
        return this.proxyMBeanManager.getDispatchers();
    }

    protected void setProxyMBeanManagerForTest(ProxyMBeanManager proxyMBeanManager) {
        this.proxyMBeanManager = proxyMBeanManager;
    }

    private void startTimer() {
        this.pingTask = new PingTask((DispatcherList)this.configuration.getDispatcherList(), this);
        this.timer.schedule((TimerTask)this.pingTask, this.pingInterval, this.pingInterval);
    }

    private void stopTimer() {
        if (this.pingTask != null) {
            this.pingTask.cancel();
        }
    }
}

