/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeThread;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class DispatcherUpdatesNotifier {
    static final PogoLogger cat = PogoLogger.getLogger();
    private ObjectName remoteDispatcherUpdatesObjectName = null;
    private DispatcherList dispatcherList;

    public DispatcherUpdatesNotifier() {
        try {
            this.remoteDispatcherUpdatesObjectName = MBeanUtils.createObjectNameInstance("type=RemoteDispatcherUpdates,*");
        }
        catch (Exception e) {
            this.remoteDispatcherUpdatesObjectName = null;
            cat.error("Unable to create object name 'type=RemoteDispatcherUpdates,*'.", e);
        }
    }

    public void notifyDispatchers(DispatcherList dispList) {
        cat.debug("notifyRemoteDispatchers() - Start notifying remote dispatchers for proxies reconfiguration.");
        this.dispatcherList = dispList;
        if (this.dispatcherList == null) {
            cat.debug("notifyRemoteDispatchers() - the dispatcher list is null, no remote dispatchers to notify.");
            return;
        }
        HashSet<DispatcherListElement> collection = this.dispatcherList.getCompleteDispatcherListElements();
        for (DispatcherListElement dle : collection) {
            NodeID aNodeID = dle.getNodeID();
            if (aNodeID == null || aNodeID.isLocalDispatcher()) continue;
            DispatcherNotifier dispatcherNotifier = this.createDispatcherNotifier(dle);
            dispatcherNotifier.start();
        }
    }

    protected DispatcherNotifier createDispatcherNotifier(DispatcherListElement dle) {
        JMXDispatcher dispatcher = new JMXDispatcher(dle);
        return new DispatcherNotifier(dispatcher);
    }

    public ObjectName getDispatcherUpdatesObjectName() {
        return this.remoteDispatcherUpdatesObjectName;
    }

    public class DispatcherNotifier
    extends SafeThread {
        private final JMXDispatcher dispatcher;

        public DispatcherNotifier(JMXDispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }

        @Override
        public void safeRun() {
            try {
                MBeanServerConnection mbeanServerConnection;
                if (DispatcherUpdatesNotifier.this.remoteDispatcherUpdatesObjectName != null && (mbeanServerConnection = this.dispatcher.getMbeanServerConnection()) != null) {
                    cat.debug("reconfiguring proxies at dispatcher: ", this.dispatcher.getName());
                    String[] parameters = new String[]{};
                    Object[] args = new Object[]{};
                    Set<ObjectName> objectNames = mbeanServerConnection.queryNames(DispatcherUpdatesNotifier.this.remoteDispatcherUpdatesObjectName, null);
                    for (ObjectName objectName : objectNames) {
                        mbeanServerConnection.invoke(objectName, "update", args, parameters);
                    }
                    return;
                }
                cat.debug("Unable to notify dispatcher '", this.dispatcher.getName(), "' since it is not connected.");
            }
            catch (Exception e) {
                cat.debug("Unable to reconfigure proxies at dispatcher: " + this.dispatcher.getName(), e);
            }
        }
    }
}

